/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import eu.toop.edm.EDMErrorResponse;
import eu.toop.edm.EDMResponse;
import eu.toop.playground.dc.ui.presenter.MainPresenter;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Objects;
import org.vaadin.olli.FileDownloadWrapper;

public class ActionButtonComponent
extends Composite<HorizontalLayout> {
    Button showResponseBtn;
    Button showErrorResponseBtn;
    Button downloadResponse;
    Button downloadErrorResponse;
    MainPresenter presenter;
    EDMResponse response;
    EDMErrorResponse errorResponse;

    public ActionButtonComponent(MainPresenter mainPresenter) {
        this.presenter = mainPresenter;
        this.showResponseBtn = new Button("show response");
        this.showErrorResponseBtn = new Button("show error");
        this.downloadResponse = new Button();
        this.downloadErrorResponse = new Button();
        this.showResponseBtn.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.showErrorResponseBtn.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY, ButtonVariant.LUMO_ERROR});
        this.downloadResponse.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.downloadErrorResponse.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY, ButtonVariant.LUMO_ERROR});
        this.downloadResponse.setIcon((Component)new Icon(VaadinIcon.DOWNLOAD_ALT));
        this.downloadErrorResponse.setIcon((Component)new Icon(VaadinIcon.DOWNLOAD_ALT));
        this.enableBtns(false);
        this.showResponseBtn.addClickListener((ComponentEventListener & Serializable)clickEvent -> mainPresenter.showResponse(this.response));
        this.showErrorResponseBtn.addClickListener((ComponentEventListener & Serializable)clickEvent -> mainPresenter.showErrorResponse(this.errorResponse));
        FileDownloadWrapper fileDownloadWrapper = new FileDownloadWrapper(new StreamResource("TOOPResponse.xml", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(Objects.requireNonNull(this.response.getWriter().getAsBytes()))));
        FileDownloadWrapper fileDownloadWrapper2 = new FileDownloadWrapper(new StreamResource("TOOPErrorResponse.xml", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(Objects.requireNonNull(this.errorResponse.getWriter().getAsBytes()))));
        fileDownloadWrapper.wrapComponent((Component)this.downloadResponse);
        fileDownloadWrapper2.wrapComponent((Component)this.downloadErrorResponse);
        ((HorizontalLayout)this.getContent()).add(new Component[]{this.showResponseBtn, fileDownloadWrapper});
        ((HorizontalLayout)this.getContent()).add(new Component[]{this.showErrorResponseBtn, fileDownloadWrapper2});
    }

    public void enableBtns(Boolean bl) {
        this.showResponseBtn.setEnabled(bl.booleanValue());
        this.downloadResponse.setEnabled(bl.booleanValue());
    }

    public void enableErrorBtns(Boolean bl) {
        this.showErrorResponseBtn.setEnabled(bl.booleanValue());
        this.downloadErrorResponse.setEnabled(bl.booleanValue());
    }

    public void showBtns(Boolean bl) {
        this.showResponseBtn.setVisible(bl.booleanValue());
        this.downloadResponse.setVisible(bl.booleanValue());
    }

    public void showErrorBtns(Boolean bl) {
        this.showErrorResponseBtn.setVisible(bl.booleanValue());
        this.downloadErrorResponse.setVisible(bl.booleanValue());
    }

    public void setResponse(EDMResponse eDMResponse) {
        this.response = eDMResponse;
    }

    public void setErrorResponse(EDMErrorResponse eDMErrorResponse) {
        this.errorResponse = eDMErrorResponse;
    }
}

