/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.servlet;

import com.helger.commons.io.stream.StreamHelper;
import eu.toop.connector.api.rest.TCIncomingMessage;
import eu.toop.connector.api.rest.TCIncomingMetadata;
import eu.toop.connector.api.rest.TCRestJAXB;
import eu.toop.edm.EDMErrorResponse;
import eu.toop.edm.EDMResponse;
import eu.toop.edm.IEDMTopLevelObject;
import eu.toop.edm.xml.EDMPayloadDeterminator;
import eu.toop.playground.dc.ui.service.BroadcasterService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="EDMResponseSimServlet", urlPatterns={"/to-dc"})
public class EDMResponseSimServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(EDMResponseSimServlet.class);

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        byte[] byArray = StreamHelper.getAllBytes((InputStream)httpServletRequest.getInputStream());
        LOGGER.info("DP Servlet got message:");
        String string = new String(byArray, StandardCharsets.UTF_8);
        LOGGER.debug("PRINTING MESSAGE\n----------------------\n{}", (Object)string);
        TCIncomingMessage tCIncomingMessage = (TCIncomingMessage)TCRestJAXB.incomingMessage().read(string);
        if (tCIncomingMessage != null) {
            LOGGER.debug("Freedonia DC Received an TC Incoming Message.");
        } else {
            LOGGER.debug("Freedonia DC Received a Null Message.");
        }
        TCIncomingMetadata tCIncomingMetadata = tCIncomingMessage.getMetadata();
        if (tCIncomingMetadata != null) {
            LOGGER.debug("Freedonia DC Received Metadata from: {}", (Object)tCIncomingMetadata.getSenderID());
        } else {
            LOGGER.debug("Freedonia DC Received null Metadata from Elonia: {}");
        }
        tCIncomingMessage.getPayload().forEach(tCPayload -> {
            LOGGER.debug("Freedonia DC Received Payload  Content ID: " + tCPayload.getContentID());
            LOGGER.debug("Freedonia DC Received Payload  Mime Type: " + tCPayload.getMimeType());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(tCPayload.getValue());
            IEDMTopLevelObject iEDMTopLevelObject = EDMPayloadDeterminator.parseAndFind((InputStream)byteArrayInputStream);
            if (iEDMTopLevelObject != null && iEDMTopLevelObject instanceof EDMResponse) {
                EDMResponse eDMResponse = (EDMResponse)iEDMTopLevelObject;
                BroadcasterService.INSTANCE.broadcast(eDMResponse);
                LOGGER.debug("Freedonia DC received EDMResponse payload:\n {}", (Object)eDMResponse.getWriter().getAsString());
            } else if (iEDMTopLevelObject != null && iEDMTopLevelObject instanceof EDMErrorResponse) {
                EDMErrorResponse eDMErrorResponse = (EDMErrorResponse)iEDMTopLevelObject;
                BroadcasterService.INSTANCE.broadcast(eDMErrorResponse);
                LOGGER.debug("Freedonia DC received EDMErrorResponse payload:\n {}", (Object)eDMErrorResponse.getWriter().getAsString());
            } else {
                LOGGER.error("Freedonia DC unable to parse incoming response.");
            }
        });
    }
}

