/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.config.enums;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public enum DCConfig {
    INSTANCE;

    private final String CONFIG_FILE = "dcui.conf";
    private final Config config;

    private DCConfig() {
        Config config = ConfigFactory.parseResources((String)"dcui.conf");
        Config config2 = ConfigFactory.parseFile((File)Paths.get("/toop-dir/demo-ui-dc/dcui.conf", new String[0]).toFile());
        Path path = Paths.get("./dcui.conf", new String[0]);
        this.config = ConfigFactory.parseFile((File)path.toFile()).withFallback((ConfigMergeable)config2).withFallback((ConfigMergeable)config).resolve();
    }

    public boolean useMockDSD() {
        return this.config.getBoolean("use-mock-dsd");
    }

    public boolean useDirectSubmit() {
        return this.config.getBoolean("use-direct-submit");
    }

    public String getSubmitRequestURL() {
        return this.useDirectSubmit() ? this.config.getString("elonia-dp-submit-request-url") : this.config.getString("sim-dp-submit-request-url");
    }

    public String getDSDEndpointURL() {
        return this.config.getString("sim-dp-dsd");
    }

    public String getDefaultEloniaDevParticipantIdScheme() {
        return this.config.getString("elonia-dp-default-participantid-scheme");
    }

    public String getDefaultEloniaDevParticipantIdValue() {
        return this.config.getString("elonia-dp-default-participantid-value");
    }

    public String getDefaultEloniaDevSenderIdScheme() {
        return this.config.getString("elonia-dp-default-senderid-scheme");
    }

    public String getDefaultEloniaDevSenderIdValue() {
        return this.config.getString("elonia-dp-default-senderid-value");
    }
}

