/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.validation;

import com.helger.bdve.api.EValidationType;
import com.helger.bdve.api.artefact.IValidationArtefact;
import com.helger.bdve.api.artefact.ValidationArtefact;
import com.helger.bdve.api.execute.ValidationExecutionManager;
import com.helger.bdve.api.executorset.IValidationExecutorSet;
import com.helger.bdve.api.executorset.VESID;
import com.helger.bdve.api.executorset.ValidationExecutorSetRegistry;
import com.helger.bdve.api.result.ValidationResult;
import com.helger.bdve.api.result.ValidationResultList;
import com.helger.bdve.api.source.IValidationSource;
import com.helger.bdve.engine.source.IValidationSourceXML;
import com.helger.bdve.engine.source.ValidationSourceXML;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.inmemory.ReadableResourceByteArray;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.sax.WrappedCollectingSAXErrorHandler;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xml.serialize.read.DOMReaderSettings;
import com.helger.xml.serialize.read.IDOMReaderSettings;
import eu.toop.connector.api.validation.IVSValidator;
import eu.toop.connector.app.validation.TCValidationRules;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

public class TCValidator
implements IVSValidator {
    private static final ValidationExecutorSetRegistry<IValidationSourceXML> VER = new ValidationExecutorSetRegistry();

    @Nonnull
    public static ValidationExecutorSetRegistry<IValidationSourceXML> internalGetRegistry() {
        return VER;
    }

    @Nonnull
    public static IValidationExecutorSet<IValidationSourceXML> getVES(@Nonnull VESID vESID) {
        IValidationExecutorSet iValidationExecutorSet = VER.getOfID(vESID);
        if (iValidationExecutorSet == null) {
            throw new IllegalStateException("Unexpected VESID '" + vESID.getAsSingleID() + "'");
        }
        return iValidationExecutorSet;
    }

    @Nonnull
    public ValidationResultList validate(@Nonnull VESID vESID, @Nonnull byte[] byArray, @Nonnull Locale locale) {
        ErrorList errorList = new ErrorList();
        ValidationResultList validationResultList = new ValidationResultList();
        ReadableResourceByteArray readableResourceByteArray = new ReadableResourceByteArray(byArray);
        Document document = DOMReader.readXMLDOM((IReadableResource)readableResourceByteArray, (IDOMReaderSettings)new DOMReaderSettings().setErrorHandler((ErrorHandler)new WrappedCollectingSAXErrorHandler(errorList)).setLocale(locale).setFeatureValues(EXMLParserFeature.AVOID_XML_ATTACKS));
        if (document != null) {
            ValidationSourceXML validationSourceXML = ValidationSourceXML.create((String)"uploaded content", (Node)DOMReader.readXMLDOM((byte[])byArray));
            ValidationExecutionManager.executeValidation(TCValidator.getVES(vESID), (IValidationSource)validationSourceXML, (ValidationResultList)validationResultList, (Locale)locale);
        }
        validationResultList.add(0, (Object)new ValidationResult((IValidationArtefact)new ValidationArtefact(EValidationType.XML, (IReadableResource)readableResourceByteArray), (IErrorList)errorList));
        return validationResultList;
    }

    static {
        TCValidationRules.initToopEDM(VER);
    }
}

