/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.validation;

import com.helger.bdve.api.EValidationType;
import com.helger.bdve.api.artefact.IValidationArtefact;
import com.helger.bdve.api.artefact.ValidationArtefact;
import com.helger.bdve.api.execute.IValidationExecutor;
import com.helger.bdve.api.executorset.IValidationExecutorSet;
import com.helger.bdve.api.executorset.VESID;
import com.helger.bdve.api.executorset.ValidationExecutorSet;
import com.helger.bdve.api.executorset.ValidationExecutorSetRegistry;
import com.helger.bdve.engine.schematron.ValidationExecutorSchematron;
import com.helger.bdve.engine.source.IValidationSourceXML;
import com.helger.bdve.engine.xsd.ValidationExecutorXSD;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.jaxb.builder.IJAXBDocumentType;
import com.helger.ubl21.UBL21NamespaceContext;
import com.helger.xml.namespace.IIterableNamespaceContext;
import eu.toop.edm.schematron.CEDMSchematron;
import eu.toop.edm.xml.cagv.CCAGV;
import eu.toop.edm.xml.cccev.CCCEV;
import eu.toop.regrep.CRegRep4;
import eu.toop.regrep.RegRep4Reader;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TCValidationRules {
    public static final String GROUP_ID = "eu.toop";
    public static final VESID VID_TOOP_EDM_REQUEST_200 = new VESID("eu.toop", "edm-request", "2.0.0");
    public static final VESID VID_TOOP_EDM_RESPONSE_200 = new VESID("eu.toop", "edm-response", "2.0.0");
    public static final VESID VID_TOOP_EDM_ERROR_RESPONSE_200 = new VESID("eu.toop", "edm-error-response", "2.0.0");

    private TCValidationRules() {
    }

    @Nonnull
    private static ClassLoader _getCL() {
        return TCValidationRules.class.getClassLoader();
    }

    @Nonnull
    private static ValidationExecutorSchematron _createXSLT(@Nonnull IReadableResource iReadableResource) {
        return new ValidationExecutorSchematron((IValidationArtefact)new ValidationArtefact(EValidationType.SCHEMATRON_XSLT, iReadableResource), null, (IIterableNamespaceContext)UBL21NamespaceContext.getInstance());
    }

    public static void initToopEDM(@Nonnull ValidationExecutorSetRegistry<IValidationSourceXML> validationExecutorSetRegistry) {
        ValueEnforcer.notNull(validationExecutorSetRegistry, (String)"Registry");
        IJAXBDocumentType iJAXBDocumentType = RegRep4Reader.queryRequest((Iterable)CCAGV.XSDS).getJAXBDocumentType();
        IValidationExecutor[] iValidationExecutorArray = new IValidationExecutor[4];
        iValidationExecutorArray[0] = new ValidationExecutorXSD((IValidationArtefact)new ValidationArtefact(EValidationType.XSD, (IReadableResource)CRegRep4.getXSDResourceQuery()), () -> ((IJAXBDocumentType)iJAXBDocumentType).getSchema());
        iValidationExecutorArray[1] = TCValidationRules._createXSLT((IReadableResource)CEDMSchematron.TOOP_IS_REQUEST).setStopValidationOnError(true);
        iValidationExecutorArray[2] = TCValidationRules._createXSLT((IReadableResource)CEDMSchematron.TOOP_EDM2_XSLT);
        iValidationExecutorArray[3] = TCValidationRules._createXSLT((IReadableResource)CEDMSchematron.TOOP_BUSINESS_RULES_XSLT);
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_TOOP_EDM_REQUEST_200, (String)"TOOP EDM Request 2.0.0", (boolean)false, (IValidationExecutor[])iValidationExecutorArray));
        iJAXBDocumentType = RegRep4Reader.queryResponse((Iterable)CCCEV.XSDS).getJAXBDocumentType();
        IValidationExecutor[] iValidationExecutorArray2 = new IValidationExecutor[4];
        iValidationExecutorArray2[0] = new ValidationExecutorXSD((IValidationArtefact)new ValidationArtefact(EValidationType.XSD, (IReadableResource)CRegRep4.getXSDResourceQuery()), () -> ((IJAXBDocumentType)iJAXBDocumentType).getSchema());
        iValidationExecutorArray2[1] = TCValidationRules._createXSLT((IReadableResource)CEDMSchematron.TOOP_IS_RESPONSE).setStopValidationOnError(true);
        iValidationExecutorArray2[2] = TCValidationRules._createXSLT((IReadableResource)CEDMSchematron.TOOP_EDM2_XSLT);
        iValidationExecutorArray2[3] = TCValidationRules._createXSLT((IReadableResource)CEDMSchematron.TOOP_BUSINESS_RULES_XSLT);
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_TOOP_EDM_RESPONSE_200, (String)"TOOP EDM Response 2.0.0", (boolean)false, (IValidationExecutor[])iValidationExecutorArray2));
        iJAXBDocumentType = RegRep4Reader.queryResponse((Iterable)CCCEV.XSDS).getJAXBDocumentType();
        IValidationExecutor[] iValidationExecutorArray3 = new IValidationExecutor[4];
        iValidationExecutorArray3[0] = new ValidationExecutorXSD((IValidationArtefact)new ValidationArtefact(EValidationType.XSD, (IReadableResource)CRegRep4.getXSDResourceQuery()), () -> ((IJAXBDocumentType)iJAXBDocumentType).getSchema());
        iValidationExecutorArray3[1] = TCValidationRules._createXSLT((IReadableResource)CEDMSchematron.TOOP_IS_ERROR_RESPONSE).setStopValidationOnError(true);
        iValidationExecutorArray3[2] = TCValidationRules._createXSLT((IReadableResource)CEDMSchematron.TOOP_EDM2_XSLT);
        iValidationExecutorArray3[3] = TCValidationRules._createXSLT((IReadableResource)CEDMSchematron.TOOP_BUSINESS_RULES_XSLT);
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_TOOP_EDM_ERROR_RESPONSE_200, (String)"TOOP EDM Error Response 2.0.0", (boolean)false, (IValidationExecutor[])iValidationExecutorArray3));
    }
}

