/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.smp;

import com.helger.commons.ValueEnforcer;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.smpclient.bdxr1.BDXRClientReadOnly;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.url.PeppolDNSResolutionException;
import com.helger.xsds.bdxr.smp1.ServiceMetadataType;
import com.helger.xsds.bdxr.smp1.SignedServiceMetadataType;
import eu.toop.connector.api.dd.IDDServiceMetadataProvider;
import eu.toop.connector.app.smp.DDServiceGroupHrefProviderSMP;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DDServiceMetadataProviderSMP
implements IDDServiceMetadataProvider {
    @Nullable
    public ServiceMetadataType getServiceMetadata(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocTypeID");
        try {
            BDXRClientReadOnly bDXRClientReadOnly = DDServiceGroupHrefProviderSMP.getSMPClient(iParticipantIdentifier);
            SignedServiceMetadataType signedServiceMetadataType = bDXRClientReadOnly.getServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier);
            if (signedServiceMetadataType == null) {
                return null;
            }
            return signedServiceMetadataType.getServiceMetadata();
        }
        catch (SMPClientException | PeppolDNSResolutionException throwable) {
            throw new IllegalStateException(throwable);
        }
    }
}

