/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.smp;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsTreeMap;
import com.helger.commons.collection.impl.ICommonsSortedMap;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.smpclient.bdxr1.BDXRClientReadOnly;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.url.BDXLURLProvider;
import com.helger.smpclient.url.IPeppolURLProvider;
import com.helger.smpclient.url.PeppolDNSResolutionException;
import com.helger.xsds.bdxr.smp1.ServiceGroupType;
import com.helger.xsds.bdxr.smp1.ServiceMetadataReferenceType;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.dd.IDDServiceGroupHrefProvider;
import eu.toop.connector.api.error.ITCErrorHandler;
import eu.toop.edm.error.EToopErrorCode;
import eu.toop.edm.error.IToopErrorCode;
import javax.annotation.Nonnull;

public class DDServiceGroupHrefProviderSMP
implements IDDServiceGroupHrefProvider {
    @Nonnull
    public static BDXRClientReadOnly getSMPClient(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws PeppolDNSResolutionException {
        if (TCConfig.R2D2.isR2D2UseDNS()) {
            ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"RecipientID");
            return new BDXRClientReadOnly((IPeppolURLProvider)BDXLURLProvider.INSTANCE, iParticipantIdentifier, TCConfig.R2D2.getR2D2SML());
        }
        return new BDXRClientReadOnly(TCConfig.R2D2.getR2D2SMPUrl());
    }

    @Nonnull
    public ICommonsSortedMap<String, String> getAllServiceGroupHrefs(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ITCErrorHandler iTCErrorHandler) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        ValueEnforcer.notNull((Object)iTCErrorHandler, (String)"ErrorHandler");
        try {
            CommonsTreeMap commonsTreeMap = new CommonsTreeMap();
            BDXRClientReadOnly bDXRClientReadOnly = DDServiceGroupHrefProviderSMP.getSMPClient(iParticipantIdentifier);
            ServiceGroupType serviceGroupType = bDXRClientReadOnly.getServiceGroupOrNull(iParticipantIdentifier);
            if (serviceGroupType != null && serviceGroupType.getServiceMetadataReferenceCollection() != null) {
                for (ServiceMetadataReferenceType serviceMetadataReferenceType : serviceGroupType.getServiceMetadataReferenceCollection().getServiceMetadataReference()) {
                    String string = CIdentifier.createPercentDecoded((String)serviceMetadataReferenceType.getHref());
                    if (commonsTreeMap.put((Object)string, (Object)serviceMetadataReferenceType.getHref()) == null) continue;
                    iTCErrorHandler.onWarning("[API] The ServiceGroup list contains the duplicate URL '" + string + "'", (IToopErrorCode)EToopErrorCode.GEN);
                }
            }
            return commonsTreeMap;
        }
        catch (SMPClientException | PeppolDNSResolutionException throwable) {
            throw new IllegalStateException(throwable);
        }
    }
}

