/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.validation;

import com.helger.bdve.EValidationType;
import com.helger.bdve.artefact.IValidationArtefact;
import com.helger.bdve.artefact.ValidationArtefact;
import com.helger.bdve.execute.ValidationExecutionManager;
import com.helger.bdve.executorset.IValidationExecutorSet;
import com.helger.bdve.executorset.VESID;
import com.helger.bdve.executorset.ValidationExecutorSetRegistry;
import com.helger.bdve.result.ValidationResult;
import com.helger.bdve.result.ValidationResultList;
import com.helger.bdve.source.IValidationSource;
import com.helger.bdve.source.ValidationSource;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.inmemory.ReadableResourceByteArray;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.sax.WrappedCollectingSAXErrorHandler;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xml.serialize.read.DOMReaderSettings;
import com.helger.xml.serialize.read.IDOMReaderSettings;
import eu.toop.connector.api.validation.IVSValidator;
import eu.toop.connector.app.validation.TCValidationRules;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;

public class TCValidator
implements IVSValidator {
    private static final ValidationExecutorSetRegistry VER = new ValidationExecutorSetRegistry();

    @Nonnull
    public static IValidationExecutorSet getVES(@Nonnull VESID vESID) {
        IValidationExecutorSet iValidationExecutorSet = VER.getOfID(vESID);
        if (iValidationExecutorSet == null) {
            throw new IllegalStateException("Unexpected VESID " + vESID.getAsSingleID());
        }
        return iValidationExecutorSet;
    }

    @Nonnull
    public ValidationResultList validate(@Nonnull VESID vESID, @Nonnull byte[] byArray, @Nonnull Locale locale) {
        ValidationExecutionManager validationExecutionManager = TCValidator.getVES(vESID).createExecutionManager();
        ErrorList errorList = new ErrorList();
        ValidationResultList validationResultList = new ValidationResultList();
        ReadableResourceByteArray readableResourceByteArray = new ReadableResourceByteArray(byArray);
        Document document = DOMReader.readXMLDOM((IReadableResource)readableResourceByteArray, (IDOMReaderSettings)new DOMReaderSettings().setErrorHandler((ErrorHandler)new WrappedCollectingSAXErrorHandler(errorList)).setLocale(locale).setFeatureValues(EXMLParserFeature.AVOID_XML_ATTACKS));
        if (document != null) {
            ValidationSource validationSource = new ValidationSource("uploaded content", (ISupplier & Serializable)() -> DOMReader.readXMLDOM((byte[])byArray), false);
            validationExecutionManager.executeValidation((IValidationSource)validationSource, validationResultList, locale);
        }
        validationResultList.add(0, (Object)new ValidationResult((IValidationArtefact)new ValidationArtefact(EValidationType.XML, null, (IReadableResource)readableResourceByteArray), (IErrorList)errorList));
        return validationResultList;
    }

    static {
        TCValidationRules.initToopEDM(VER);
    }
}

