/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.validation;

import com.helger.bdve.EValidationType;
import com.helger.bdve.artefact.IValidationArtefact;
import com.helger.bdve.artefact.ValidationArtefact;
import com.helger.bdve.execute.IValidationExecutor;
import com.helger.bdve.execute.ValidationExecutorSchematron;
import com.helger.bdve.execute.ValidationExecutorXSD;
import com.helger.bdve.executorset.IValidationExecutorSet;
import com.helger.bdve.executorset.VESID;
import com.helger.bdve.executorset.ValidationExecutorSet;
import com.helger.bdve.executorset.ValidationExecutorSetRegistry;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.jaxb.builder.IJAXBDocumentType;
import com.helger.ubl21.UBL21NamespaceContext;
import com.helger.xml.namespace.IIterableNamespaceContext;
import eu.toop.edm.schematron.SchematronBusinessRules2Validator;
import eu.toop.edm.schematron.SchematronEDM2Validator;
import eu.toop.edm.xml.cagv.CCAGV;
import eu.toop.edm.xml.cccev.CCCEV;
import eu.toop.regrep.CRegRep4;
import eu.toop.regrep.RegRep4Reader;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TCValidationRules {
    public static final String GROUP_ID = "eu.toop";
    public static final VESID VID_TOOP_EDM_REQUEST_200 = new VESID("eu.toop", "edm-request", "2.0.0");
    public static final VESID VID_TOOP_EDM_RESPONSE_200 = new VESID("eu.toop", "edm-response", "2.0.0");
    public static final VESID VID_TOOP_EDM_ERROR_RESPONSE_200 = new VESID("eu.toop", "edm-error-response", "2.0.0");
    private static final ClassPathResource TOOP_BUSINESS_RULES_XSLT = SchematronBusinessRules2Validator.TOOP_BUSINESS_RULES_XSLT;
    private static final ClassPathResource TOOP_EDM2_XSLT = SchematronEDM2Validator.TOOP_EDM2_XSLT;

    private TCValidationRules() {
    }

    @Nonnull
    private static ClassLoader _getCL() {
        return TCValidationRules.class.getClassLoader();
    }

    @Nonnull
    private static IValidationExecutor _createXSLT(@Nonnull IReadableResource iReadableResource) {
        return new ValidationExecutorSchematron((IValidationArtefact)new ValidationArtefact(EValidationType.SCHEMATRON_XSLT, TCValidationRules._getCL(), iReadableResource), null, (IIterableNamespaceContext)UBL21NamespaceContext.getInstance());
    }

    public static void initToopEDM(@Nonnull ValidationExecutorSetRegistry validationExecutorSetRegistry) {
        ValueEnforcer.notNull((Object)validationExecutorSetRegistry, (String)"Registry");
        IJAXBDocumentType iJAXBDocumentType = RegRep4Reader.queryRequest((Iterable)CCAGV.XSDS).getJAXBDocumentType();
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_TOOP_EDM_REQUEST_200, (String)"TOOP EDM Request 2.0.0", (boolean)false, (IValidationExecutor[])new IValidationExecutor[]{new ValidationExecutorXSD((IValidationArtefact)new ValidationArtefact(EValidationType.XSD, TCValidationRules._getCL(), (IReadableResource)CRegRep4.getXSDResourceQuery()), (ISupplier & Serializable)() -> iJAXBDocumentType.getSchema()), TCValidationRules._createXSLT((IReadableResource)TOOP_EDM2_XSLT), TCValidationRules._createXSLT((IReadableResource)TOOP_BUSINESS_RULES_XSLT)}));
        iJAXBDocumentType = RegRep4Reader.queryResponse((Iterable)CCCEV.XSDS).getJAXBDocumentType();
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_TOOP_EDM_RESPONSE_200, (String)"TOOP EDM Response 2.0.0", (boolean)false, (IValidationExecutor[])new IValidationExecutor[]{new ValidationExecutorXSD((IValidationArtefact)new ValidationArtefact(EValidationType.XSD, TCValidationRules._getCL(), (IReadableResource)CRegRep4.getXSDResourceQuery()), (ISupplier & Serializable)() -> iJAXBDocumentType.getSchema()), TCValidationRules._createXSLT((IReadableResource)TOOP_EDM2_XSLT), TCValidationRules._createXSLT((IReadableResource)TOOP_BUSINESS_RULES_XSLT)}));
        iJAXBDocumentType = RegRep4Reader.queryResponse().getJAXBDocumentType();
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((VESID)VID_TOOP_EDM_ERROR_RESPONSE_200, (String)"TOOP EDM Error Response 2.0.0", (boolean)false, (IValidationExecutor[])new IValidationExecutor[]{new ValidationExecutorXSD((IValidationArtefact)new ValidationArtefact(EValidationType.XSD, TCValidationRules._getCL(), (IReadableResource)CRegRep4.getXSDResourceQuery()), (ISupplier & Serializable)() -> iJAXBDocumentType.getSchema()), TCValidationRules._createXSLT((IReadableResource)TOOP_EDM2_XSLT), TCValidationRules._createXSLT((IReadableResource)TOOP_BUSINESS_RULES_XSLT)}));
    }
}

