/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.dsd;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.string.ToStringGenerator;
import com.helger.httpclient.HttpClientSettings;
import com.helger.pd.searchapi.v1.IDType;
import com.helger.pd.searchapi.v1.MatchType;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.dd.IDDErrorHandler;
import eu.toop.connector.api.dsd.IDSDParticipantIDProvider;
import eu.toop.connector.api.http.TCHttpClientSettings;
import eu.toop.dsd.client.DSDClient;
import eu.toop.edm.error.EToopErrorCode;
import eu.toop.edm.error.IToopErrorCode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DSDParticipantIDProviderRemote
implements IDSDParticipantIDProvider {
    private final String m_sBaseURL;

    public DSDParticipantIDProviderRemote() {
        this(TCConfig.DSD.getR2D2DirectoryBaseUrl());
    }

    public DSDParticipantIDProviderRemote(@Nonnull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"BaseURL");
        this.m_sBaseURL = string;
    }

    @Nonnull
    @Nonempty
    public final String getBaseURL() {
        return this.m_sBaseURL;
    }

    @Nonnull
    public ICommonsSet<IParticipantIdentifier> getAllParticipantIDs(@Nonnull String string, @Nonnull String string2, @Nullable String string3, @Nullable IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IDDErrorHandler iDDErrorHandler) {
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        DSDClient dSDClient = new DSDClient(this.m_sBaseURL);
        dSDClient.setHttpClientSettings((HttpClientSettings)new TCHttpClientSettings());
        List list = null;
        try {
            list = dSDClient.queryDatasetAsMatchTypes(string2, string3);
        }
        catch (RuntimeException runtimeException) {
            iDDErrorHandler.onError("Failed to query the DSD", (Throwable)runtimeException, (IToopErrorCode)EToopErrorCode.DD_001);
        }
        if (list != null) {
            for (MatchType matchType : list) {
                boolean bl = false;
                if (iDocumentTypeIdentifier == null) {
                    bl = true;
                } else {
                    for (IDType iDType : matchType.getDocTypeID()) {
                        if (!iDocumentTypeIdentifier.hasScheme(iDType.getScheme()) || !iDocumentTypeIdentifier.hasValue(iDType.getValue())) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) continue;
                commonsHashSet.add((Object)TCConfig.getIdentifierFactory().createParticipantIdentifier(matchType.getParticipantID().getScheme(), matchType.getParticipantID().getValue()));
            }
        }
        return commonsHashSet;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("BaseURL", (Object)this.m_sBaseURL).getToString();
    }
}

