/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.dsd;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.httpclient.HttpClientSettings;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.dd.IDDErrorHandler;
import eu.toop.connector.api.dsd.DSDDatasetResponse;
import eu.toop.connector.api.dsd.IDSDDatasetResponseProvider;
import eu.toop.connector.api.http.TCHttpClientSettings;
import eu.toop.dsd.client.DSDClient;
import eu.toop.edm.error.EToopErrorCode;
import eu.toop.edm.error.IToopErrorCode;
import eu.toop.edm.jaxb.cv.agent.PublicOrganizationType;
import eu.toop.edm.jaxb.cv.cbc.IDType;
import eu.toop.edm.jaxb.dcatap.DCatAPDatasetType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSDDatasetResponseProviderRemote
implements IDSDDatasetResponseProvider {
    private final String m_sBaseURL;
    private static final Logger logger = LoggerFactory.getLogger(DSDDatasetResponseProviderRemote.class);

    public DSDDatasetResponseProviderRemote() {
        this(TCConfig.DSD.getR2D2DirectoryBaseUrl());
    }

    public DSDDatasetResponseProviderRemote(@Nonnull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"BaseURL");
        this.m_sBaseURL = string;
    }

    @Nonnull
    @Nonempty
    public final String getBaseURL() {
        return this.m_sBaseURL;
    }

    @Nonnull
    public ICommonsSet<DSDDatasetResponse> getAllDatasetResponses(@Nonnull String string, @Nonnull String string2, @Nullable String string3, @Nonnull IDDErrorHandler iDDErrorHandler) {
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        DSDClient dSDClient = new DSDClient(this.m_sBaseURL);
        dSDClient.setHttpClientSettings((HttpClientSettings)new TCHttpClientSettings());
        try {
            List list = dSDClient.queryDataset(string2, string3);
            list.forEach(arg_0 -> DSDDatasetResponseProviderRemote.lambda$getAllDatasetResponses$1((ICommonsSet)commonsHashSet, arg_0));
        }
        catch (RuntimeException runtimeException) {
            logger.error(runtimeException.getMessage(), (Throwable)runtimeException);
            iDDErrorHandler.onError("Failed to query the DSD", (Throwable)runtimeException, (IToopErrorCode)EToopErrorCode.DD_001);
        }
        return commonsHashSet;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("BaseURL", (Object)this.m_sBaseURL).getToString();
    }

    private static /* synthetic */ void lambda$getAllDatasetResponses$1(ICommonsSet iCommonsSet, DCatAPDatasetType dCatAPDatasetType) {
        dCatAPDatasetType.getDistribution().forEach(dCatAPDistributionType -> {
            DSDDatasetResponse dSDDatasetResponse = new DSDDatasetResponse();
            if (dCatAPDistributionType.getAccessService().hasConformsToEntries()) {
                dSDDatasetResponse.setAccessServiceConforms(dCatAPDistributionType.getAccessService().getConformsToAtIndex(0).getValue());
            }
            IDType iDType = ((PublicOrganizationType)dCatAPDatasetType.getPublisherAtIndex(0)).getIdAtIndex(0);
            dSDDatasetResponse.setDPIdentifier(TCConfig.getIdentifierFactory().createParticipantIdentifier(iDType.getSchemeName(), iDType.getValue()));
            ICommonsList iCommonsList = StringHelper.getExploded((String)"::", (String)dCatAPDistributionType.getAccessService().getIdentifier(), (int)2);
            if (iCommonsList.size() == 2) {
                dSDDatasetResponse.setDocumentTypeIdentifier(TCConfig.getIdentifierFactory().createDocumentTypeIdentifier((String)iCommonsList.get(0), (String)iCommonsList.get(1)));
            }
            dSDDatasetResponse.setDatasetIdentifier(dCatAPDatasetType.getIdentifierAtIndex(0));
            if (dCatAPDistributionType.hasConformsToEntries()) {
                dSDDatasetResponse.setDistributionConforms(dCatAPDistributionType.getConformsToAtIndex(0).getValue());
            }
            dSDDatasetResponse.setDistributionFormat(dCatAPDistributionType.getFormat().getContentAtIndex(0).toString());
            iCommonsSet.add((Object)dSDDatasetResponse);
        });
    }
}

