/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.dd;

import com.helger.commons.collection.impl.CommonsTreeMap;
import com.helger.commons.collection.impl.ICommonsSortedMap;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.smpclient.bdxr1.BDXRClientReadOnly;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.url.PeppolDNSResolutionException;
import com.helger.xsds.bdxr.smp1.ServiceGroupType;
import com.helger.xsds.bdxr.smp1.ServiceMetadataReferenceType;
import eu.toop.connector.api.dd.IDDServiceGroupHrefProvider;
import eu.toop.connector.app.dd.DDEndpointProviderSMP;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDServiceGroupHrefProviderSMP
implements IDDServiceGroupHrefProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DDServiceGroupHrefProviderSMP.class);

    @Nonnull
    public ICommonsSortedMap<String, String> getAllServiceGroupHrefs(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        try {
            CommonsTreeMap commonsTreeMap = new CommonsTreeMap();
            BDXRClientReadOnly bDXRClientReadOnly = DDEndpointProviderSMP.getSMPClient(iParticipantIdentifier);
            ServiceGroupType serviceGroupType = bDXRClientReadOnly.getServiceGroupOrNull(iParticipantIdentifier);
            if (serviceGroupType != null && serviceGroupType.getServiceMetadataReferenceCollection() != null) {
                for (ServiceMetadataReferenceType serviceMetadataReferenceType : serviceGroupType.getServiceMetadataReferenceCollection().getServiceMetadataReference()) {
                    String string = CIdentifier.createPercentDecoded((String)serviceMetadataReferenceType.getHref());
                    if (commonsTreeMap.put((Object)string, (Object)serviceMetadataReferenceType.getHref()) == null) continue;
                    LOGGER.warn("[API] The ServiceGroup list contains the duplicate URL '" + string + "'");
                }
            }
            return commonsTreeMap;
        }
        catch (SMPClientException | PeppolDNSResolutionException throwable) {
            throw new IllegalStateException(throwable);
        }
    }
}

