/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.dd;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.simple.process.SimpleProcessIdentifier;
import com.helger.smpclient.bdxr1.BDXRClientReadOnly;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.url.BDXLURLProvider;
import com.helger.smpclient.url.IPeppolURLProvider;
import com.helger.smpclient.url.PeppolDNSResolutionException;
import com.helger.xsds.bdxr.smp1.EndpointType;
import com.helger.xsds.bdxr.smp1.ProcessIdentifierType;
import com.helger.xsds.bdxr.smp1.ProcessType;
import com.helger.xsds.bdxr.smp1.ServiceInformationType;
import com.helger.xsds.bdxr.smp1.SignedServiceMetadataType;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.dd.DDEndpoint;
import eu.toop.connector.api.dd.IDDEndpoint;
import eu.toop.connector.api.dd.IDDEndpointProvider;
import eu.toop.connector.api.dd.IDDErrorHandler;
import eu.toop.edm.error.EToopErrorCode;
import eu.toop.edm.error.IToopErrorCode;
import eu.toop.kafkaclient.ToopKafkaClient;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DDEndpointProviderSMP
implements IDDEndpointProvider {
    @Nonnull
    public static BDXRClientReadOnly getSMPClient(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws PeppolDNSResolutionException {
        if (TCConfig.R2D2.isR2D2UseDNS()) {
            return new BDXRClientReadOnly((IPeppolURLProvider)BDXLURLProvider.INSTANCE, iParticipantIdentifier, TCConfig.R2D2.getR2D2SML());
        }
        return new BDXRClientReadOnly(TCConfig.R2D2.getR2D2SMPUrl());
    }

    @Nullable
    public IDDEndpoint getEndpoint(@Nonnull String string, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull @Nonempty String string2, @Nonnull IDDErrorHandler iDDErrorHandler) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"Recipient");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcessID");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"TransportProfileID");
        ValueEnforcer.notNull((Object)iDDErrorHandler, (String)"ErrorHandler");
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string + "SMP lookup (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + string2 + ")");
        try {
            ServiceInformationType serviceInformationType;
            BDXRClientReadOnly bDXRClientReadOnly = DDEndpointProviderSMP.getSMPClient(iParticipantIdentifier);
            SignedServiceMetadataType signedServiceMetadataType = bDXRClientReadOnly.getServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier);
            ServiceInformationType serviceInformationType2 = serviceInformationType = signedServiceMetadataType == null ? null : signedServiceMetadataType.getServiceMetadata().getServiceInformation();
            if (serviceInformationType != null) {
                ProcessType processType2 = (ProcessType)CollectionHelper.findFirst((Iterable)serviceInformationType.getProcessList().getProcess(), processType -> SimpleProcessIdentifier.wrap((ProcessIdentifierType)processType.getProcessIdentifier()).hasSameContent(iProcessIdentifier));
                if (processType2 != null) {
                    for (EndpointType endpointType : processType2.getServiceEndpointList().getEndpoint()) {
                        if (!string2.equals(endpointType.getTransportProfile())) continue;
                        X509Certificate x509Certificate = BDXRClientReadOnly.getEndpointCertificate((EndpointType)endpointType);
                        if (StringHelper.hasNoText((String)endpointType.getEndpointURI())) {
                            ToopKafkaClient.send((IErrorLevel)EErrorLevel.WARN, () -> string + "SMP lookup result: endpoint has no URI");
                            continue;
                        }
                        DDEndpoint dDEndpoint = new DDEndpoint(iParticipantIdentifier, endpointType.getTransportProfile(), endpointType.getEndpointURI(), x509Certificate);
                        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string + "SMP lookup result: " + endpointType.getTransportProfile() + ", " + endpointType.getEndpointURI());
                        return dDEndpoint;
                    }
                }
            } else {
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string + "SMP lookup result: maybe a redirect?");
            }
            iDDErrorHandler.onWarning("Endpoint lookup for '" + iParticipantIdentifier.getURIEncoded() + "' and document type ID '" + iDocumentTypeIdentifier.getURIEncoded() + "' and process ID '" + iProcessIdentifier.getURIEncoded() + "' and transport profile '" + string2 + "' returned in no endpoints", (IToopErrorCode)EToopErrorCode.DD_004);
        }
        catch (SMPClientException | PeppolDNSResolutionException throwable) {
            iDDErrorHandler.onError(string + "Error fetching SMP endpoint " + iParticipantIdentifier.getURIEncoded() + "/" + iDocumentTypeIdentifier.getURIEncoded() + "/" + iProcessIdentifier.getURIEncoded(), throwable, (IToopErrorCode)EToopErrorCode.DD_002);
        }
        catch (CertificateException certificateException) {
            iDDErrorHandler.onError(string + "Error validating the signature from SMP response for endpoint " + iParticipantIdentifier.getURIEncoded() + "/" + iDocumentTypeIdentifier.getURIEncoded() + "/" + iProcessIdentifier.getURIEncoded(), (Throwable)certificateException, (IToopErrorCode)EToopErrorCode.DD_003);
        }
        return null;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

