/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app;

import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.id.factory.IStringIDFactory;
import com.helger.commons.id.factory.StringIDFromGlobalPersistentLongIDFactory;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.URLProtocolRegistry;
import com.helger.xservlet.requesttrack.RequestTracker;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.me.MessageExchangeManager;
import eu.toop.connector.api.me.incoming.IMEIncomingHandler;
import eu.toop.connector.api.me.incoming.IncomingEDMErrorResponse;
import eu.toop.connector.api.me.incoming.IncomingEDMRequest;
import eu.toop.connector.api.me.incoming.IncomingEDMResponse;
import eu.toop.connector.api.me.incoming.MEIncomingException;
import eu.toop.connector.app.CTC;
import eu.toop.connector.app.incoming.MPTrigger;
import eu.toop.kafkaclient.ToopKafkaClient;
import eu.toop.kafkaclient.ToopKafkaSettings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.ServletContext;

@NotThreadSafe
public class TCInit {
    private static final AtomicBoolean INITED = new AtomicBoolean(false);
    private static String s_sLogPrefix;

    private TCInit() {
    }

    public static void initGlobally(@Nonnull ServletContext servletContext) {
        Object object;
        String string;
        if (!INITED.compareAndSet(false, true)) {
            throw new IllegalStateException("TOOP Connector NG is already initialized");
        }
        GlobalIDFactory.setPersistentStringIDFactory((IStringIDFactory)new StringIDFromGlobalPersistentLongIDFactory("toop-tc-"));
        GlobalDebug.setDebugModeDirect((boolean)TCConfig.Global.isGlobalDebug());
        GlobalDebug.setProductionModeDirect((boolean)TCConfig.Global.isGlobalProduction());
        String string2 = TCConfig.Global.getToopInstanceName();
        if (StringHelper.hasNoText((String)string2)) {
            try {
                string2 = "[" + InetAddress.getLocalHost().getHostAddress() + "] ";
            }
            catch (UnknownHostException unknownHostException) {
                string2 = "";
            }
        } else {
            if (!string2.startsWith("[")) {
                string2 = "[" + string2 + "]";
            }
            string2 = string2 + " ";
        }
        s_sLogPrefix = string2;
        RequestTracker.getInstance().getRequestTrackingMgr().setLongRunningCheckEnabled(false);
        RequestTracker.getInstance().getRequestTrackingMgr().setParallelRunningRequestCheckEnabled(false);
        ToopKafkaSettings.setKafkaEnabled((boolean)TCConfig.Tracker.isToopTrackerEnabled());
        if (TCConfig.Tracker.isToopTrackerEnabled()) {
            string = TCConfig.Tracker.getToopTrackerUrl();
            if (StringHelper.hasNoText((String)string)) {
                throw new InitializationException("If the tracker is enabled, the tracker URL MUST be provided in the configuration file!");
            }
            object = URLProtocolRegistry.getInstance().getProtocol(string);
            if (object != null) {
                throw new InitializationException("The tracker URL MUST NOT start with a protocol like '" + object.getProtocol() + "'!");
            }
            ToopKafkaSettings.defaultProperties().put((Object)"bootstrap.servers", (Object)string);
            String string3 = TCConfig.Tracker.getToopTrackerTopic();
            ToopKafkaSettings.setKafkaTopic((String)string3);
        }
        if (StringHelper.hasNoText((String)(string = TCConfig.DSD.getR2D2DirectoryBaseUrl()))) {
            throw new InitializationException("The URL of the DSD Service is missing in the configuration file!");
        }
        if (!TCConfig.R2D2.isR2D2UseDNS() && (object = TCConfig.R2D2.getR2D2SMPUrl()) == null) {
            throw new InitializationException("Since the usage of SML/DNS is disabled, the fixed URL of the SMP to be used must be provided in the configuration file!");
        }
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> s_sLogPrefix + "TOOP Connector NG WebApp " + CTC.getVersionNumber() + " startup");
        MessageExchangeManager.getConfiguredImplementation().registerIncomingHandler(servletContext, new IMEIncomingHandler(){

            public void handleIncomingRequest(@Nonnull IncomingEDMRequest incomingEDMRequest) throws MEIncomingException {
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> s_sLogPrefix + "TC got DP incoming MEM request (2/4)");
                MPTrigger.forwardMessage(incomingEDMRequest);
            }

            public void handleIncomingResponse(@Nonnull IncomingEDMResponse incomingEDMResponse) throws MEIncomingException {
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> s_sLogPrefix + "TC got DC incoming MEM response (4/4) with " + incomingEDMResponse.attachments().size() + " attachments");
                MPTrigger.forwardMessage(incomingEDMResponse);
            }

            public void handleIncomingErrorResponse(@Nonnull IncomingEDMErrorResponse incomingEDMErrorResponse) throws MEIncomingException {
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> s_sLogPrefix + "TC got DC incoming MEM response (4/4) with ERRORs");
                MPTrigger.forwardMessage(incomingEDMErrorResponse);
            }
        });
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> s_sLogPrefix + "TOOP Connector NG started");
    }

    public static boolean isInitialized() {
        return INITED.get();
    }

    public static void shutdownGlobally(@Nonnull ServletContext servletContext) {
        if (!TCInit.isInitialized()) {
            throw new IllegalStateException("TOOP Connector NG is not initialized");
        }
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> s_sLogPrefix + "TOOP Connector NG shutting down");
        MessageExchangeManager.getConfiguredImplementation().shutdown(servletContext);
        ToopKafkaClient.close();
        s_sLogPrefix = null;
        if (!INITED.compareAndSet(true, false)) {
            throw new IllegalStateException("TOOP Connector NG is already shutdown");
        }
    }
}

