/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.api.me.incoming;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.connector.api.me.incoming.IIncomingEDMRequest;
import eu.toop.connector.api.me.incoming.IMEIncomingTransportMetadata;
import eu.toop.edm.EDMRequest;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class IncomingEDMRequest
implements IIncomingEDMRequest {
    private final EDMRequest m_aRequest;
    private final String m_sTopLevelContentID;
    private final IMEIncomingTransportMetadata m_aMetadata;

    public IncomingEDMRequest(@Nonnull EDMRequest eDMRequest, @Nonnull @Nonempty String string, @Nonnull IMEIncomingTransportMetadata iMEIncomingTransportMetadata) {
        ValueEnforcer.notNull((Object)eDMRequest, (String)"Request");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"TopLevelContentID");
        ValueEnforcer.notNull((Object)iMEIncomingTransportMetadata, (String)"Metadata");
        this.m_aRequest = eDMRequest;
        this.m_sTopLevelContentID = string;
        this.m_aMetadata = iMEIncomingTransportMetadata;
    }

    @Nonnull
    public EDMRequest getRequest() {
        return this.m_aRequest;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getTopLevelContentID() {
        return this.m_sTopLevelContentID;
    }

    @Override
    @Nonnull
    public IMEIncomingTransportMetadata getMetadata() {
        return this.m_aMetadata;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        IncomingEDMRequest incomingEDMRequest = (IncomingEDMRequest)object;
        return this.m_aRequest.equals((Object)incomingEDMRequest.m_aRequest) && this.m_aMetadata.equals(incomingEDMRequest.m_aMetadata);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aRequest).append((Object)this.m_aMetadata).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Request", (Object)this.m_aRequest).append("TopLevelContentID", (Object)this.m_sTopLevelContentID).append("Metadata", (Object)this.m_aMetadata).getToString();
    }
}

