/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.api;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.URLHelper;
import com.helger.config.Config;
import com.helger.config.ConfigFactory;
import com.helger.config.IConfig;
import com.helger.config.source.MultiConfigurationValueProvider;
import com.helger.config.value.IConfigurationValueProvider;
import com.helger.peppol.sml.ESML;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppol.sml.SMLInfo;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.security.certificate.CertificateHelper;
import eu.toop.connector.api.TCIdentifierFactory;
import eu.toop.connector.api.me.EMEProtocol;
import java.net.URI;
import java.security.cert.X509Certificate;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class TCConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(TCConfig.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static IConfig s_aConfig;

    private TCConfig() {
    }

    @Nonnull
    public static IConfig getConfig() {
        return (IConfig)s_aRWLock.readLockedGet(() -> s_aConfig);
    }

    public static void setConfig(@Nonnull IConfig iConfig) {
        ValueEnforcer.notNull((Object)iConfig, (String)"Config");
        s_aRWLock.writeLockedGet(() -> {
            s_aConfig = iConfig;
            return s_aConfig;
        });
    }

    public static void setDefaultConfig() {
        MultiConfigurationValueProvider multiConfigurationValueProvider = ConfigFactory.createDefaultValueProvider();
        Config config = Config.create((IConfigurationValueProvider)multiConfigurationValueProvider);
        TCConfig.setConfig((IConfig)config);
    }

    @Nonnull
    public static IIdentifierFactory getIdentifierFactory() {
        return TCIdentifierFactory.INSTANCE_TC;
    }

    static {
        TCConfig.setDefaultConfig();
    }

    public static final class WebApp {
        private WebApp() {
        }

        public static boolean isStatusEnabled() {
            return TCConfig.getConfig().getAsBoolean((Object)"toop.webapp.status.enabled", true);
        }

        @Nullable
        public static String getDataPath() {
            return TCConfig.getConfig().getAsString((Object)"toop.webapp.data.path");
        }
    }

    public static final class HTTP {
        private HTTP() {
        }

        public static boolean isProxyServerEnabled() {
            return TCConfig.getConfig().getAsBoolean((Object)"http.proxy.enabled", false);
        }

        @Nullable
        public static String getProxyServerAddress() {
            return TCConfig.getConfig().getAsString((Object)"http.proxy.address");
        }

        @CheckForSigned
        public static int getProxyServerPort() {
            return TCConfig.getConfig().getAsInt((Object)"http.proxy.port", -1);
        }

        @Nullable
        public static String getProxyServerNonProxyHosts() {
            return TCConfig.getConfig().getAsString((Object)"http.proxy.non-proxy");
        }

        public static boolean isTLSTrustAll() {
            return TCConfig.getConfig().getAsBoolean((Object)"http.tls.trustall", false);
        }

        public static int getConnectionTimeoutMS() {
            return TCConfig.getConfig().getAsInt((Object)"http.connection-timeout", -1);
        }

        public static int getReadTimeoutMS() {
            return TCConfig.getConfig().getAsInt((Object)"http.read-timeout", -1);
        }
    }

    public static final class MEM {
        private MEM() {
        }

        @Nullable
        public static String getMEMImplementationID() {
            return TCConfig.getConfig().getAsString((Object)"toop.mem.implementation");
        }

        @Nonnull
        public static EMEProtocol getMEMProtocol() {
            String string = TCConfig.getConfig().getAsString((Object)"toop.mem.protocol", EMEProtocol.DEFAULT.getID());
            EMEProtocol eMEProtocol = EMEProtocol.getFromIDOrNull(string);
            if (eMEProtocol == null) {
                throw new IllegalStateException("Failed to resolve protocol with ID '" + string + "'");
            }
            return eMEProtocol;
        }

        @Nullable
        public static String getMEMAS4Endpoint() {
            return TCConfig.getConfig().getAsString((Object)"toop.mem.as4.endpoint");
        }

        @Nullable
        public static String getMEMAS4GwPartyID() {
            return TCConfig.getConfig().getAsString((Object)"toop.mem.as4.gw.partyid");
        }

        @Nullable
        public static String getMEMAS4TcPartyid() {
            return TCConfig.getConfig().getAsString((Object)"toop.mem.as4.tc.partyid");
        }

        @Nullable
        public static String getToPartyIdType() {
            return TCConfig.getConfig().getAsString((Object)"toop.mem.as4.to-party-id-type");
        }

        public static long getGatewayNotificationWaitTimeout() {
            return TCConfig.getConfig().getAsLong((Object)"toop.mem.as4.notificationWaitTimeout", 20000L);
        }

        @Nullable
        public static String getMEMIncomingURL() {
            return TCConfig.getConfig().getAsString((Object)"toop.mem.incoming.url");
        }

        public static boolean isMEMOutgoingDumpEnabled() {
            return TCConfig.getConfig().getAsBoolean((Object)"toop.mem.outgoing.dump.enabled", false);
        }

        @Nullable
        public static String getMEMOutgoingDumpPath() {
            return TCConfig.getConfig().getAsString((Object)"toop.mem.outgoing.dump.path");
        }

        public static boolean isMEMIncomingDumpEnabled() {
            return TCConfig.getConfig().getAsBoolean((Object)"toop.mem.incoming.dump.enabled", false);
        }

        @Nullable
        public static String getMEMIncomingDumpPath() {
            return TCConfig.getConfig().getAsString((Object)"toop.mem.incoming.dump.path");
        }
    }

    public static final class R2D2 {
        public static final boolean DEFAULT_USE_SML = true;
        private static ISMLInfo s_aCachedSMLInfo;

        private R2D2() {
        }

        @Nullable
        public static String getR2D2StaticEndpointURL() {
            return TCConfig.getConfig().getAsString((Object)"toop.r2d2.static.endpointurl");
        }

        @Nullable
        public static X509Certificate getR2D2StaticCertificate() {
            String string = TCConfig.getConfig().getAsString((Object)"toop.r2d2.static.certificate");
            if (StringHelper.hasNoText((String)string)) {
                return null;
            }
            X509Certificate x509Certificate = CertificateHelper.convertStringToCertficateOrNull((String)string);
            if (x509Certificate == null) {
                LOGGER.error("The provided static R2D2 certificate could NOT be parsed");
            }
            return x509Certificate;
        }

        public static boolean isR2D2UseDNS() {
            return TCConfig.getConfig().getAsBoolean((Object)"toop.r2d2.usedns", true);
        }

        @Nonnull
        public static ISMLInfo getR2D2SML() {
            ISMLInfo iSMLInfo = s_aCachedSMLInfo;
            if (iSMLInfo == null) {
                String string = TCConfig.getConfig().getAsString((Object)"toop.r2d2.sml.id");
                ESML eSML = ESML.getFromIDOrNull((String)string);
                if (eSML != null) {
                    iSMLInfo = eSML;
                } else {
                    String string2 = TCConfig.getConfig().getAsString((Object)"toop.r2d2.sml.name", "TOOP SML");
                    String string3 = TCConfig.getConfig().getAsString((Object)"toop.r2d2.sml.dnszone");
                    String string4 = TCConfig.getConfig().getAsString((Object)"toop.r2d2.sml.serviceurl");
                    boolean bl = TCConfig.getConfig().getAsBoolean((Object)"toop.r2d2.sml.clientcert", false);
                    iSMLInfo = new SMLInfo(GlobalIDFactory.getNewStringID(), string2, string3, string4, bl);
                }
                s_aCachedSMLInfo = iSMLInfo;
            }
            return iSMLInfo;
        }

        @Nullable
        public static URI getR2D2SMPUrl() {
            String string = TCConfig.getConfig().getAsString((Object)"toop.r2d2.smp.url");
            return URLHelper.getAsURI((String)string);
        }
    }

    public static final class DSD {
        private DSD() {
        }

        @Nullable
        public static String getDSDBaseUrl() {
            return TCConfig.getConfig().getAsString((Object)"toop.dsd.service.baseurl");
        }
    }

    public static final class Tracker {
        public static final boolean DEFAULT_TOOP_TRACKER_ENABLED = false;
        public static final String DEFAULT_TOOP_TRACKER_TOPIC = "toop";

        private Tracker() {
        }

        public static boolean isToopTrackerEnabled() {
            return TCConfig.getConfig().getAsBoolean((Object)"toop.tracker.enabled", false);
        }

        @Nullable
        public static String getToopTrackerUrl() {
            return TCConfig.getConfig().getAsString((Object)"toop.tracker.url");
        }

        @Nullable
        public static String getToopTrackerTopic() {
            return TCConfig.getConfig().getAsString((Object)"toop.tracker.topic", DEFAULT_TOOP_TRACKER_TOPIC);
        }
    }

    public static final class Global {
        private Global() {
        }

        public static boolean isGlobalDebug() {
            return TCConfig.getConfig().getAsBoolean((Object)"global.debug", GlobalDebug.isDebugMode());
        }

        public static boolean isGlobalProduction() {
            return TCConfig.getConfig().getAsBoolean((Object)"global.production", GlobalDebug.isProductionMode());
        }

        @Nullable
        public static String getToopInstanceName() {
            return TCConfig.getConfig().getAsString((Object)"global.instancename");
        }
    }
}

