/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.api.me.outgoing;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.security.certificate.CertificateHelper;
import eu.toop.connector.api.me.outgoing.IMERoutingInformation;
import eu.toop.connector.api.me.outgoing.MERoutingInformationInput;
import eu.toop.connector.api.rest.TCOutgoingMetadata;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;

public class MERoutingInformation
extends MERoutingInformationInput
implements IMERoutingInformation {
    private final String m_sEndpointURL;
    private final X509Certificate m_aCert;

    public MERoutingInformation(@Nonnull MERoutingInformationInput mERoutingInformationInput, @Nonnull @Nonempty String string, @Nonnull X509Certificate x509Certificate) {
        this(mERoutingInformationInput.getSenderID(), mERoutingInformationInput.getReceiverID(), mERoutingInformationInput.getDocumentTypeID(), mERoutingInformationInput.getProcessID(), mERoutingInformationInput.getTransportProtocol(), string, x509Certificate);
    }

    public MERoutingInformation(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IParticipantIdentifier iParticipantIdentifier2, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull X509Certificate x509Certificate) {
        super(iParticipantIdentifier, iParticipantIdentifier2, iDocumentTypeIdentifier, iProcessIdentifier, string);
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"EndpointURL");
        ValueEnforcer.notNull((Object)x509Certificate, (String)"Cert");
        this.m_sEndpointURL = string2;
        this.m_aCert = x509Certificate;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getEndpointURL() {
        return this.m_sEndpointURL;
    }

    @Override
    @Nonnull
    public X509Certificate getCertificate() {
        return this.m_aCert;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("EndpointURL", (Object)this.m_sEndpointURL).append("Cert", (Object)this.m_aCert).getToString();
    }

    @Nonnull
    public static MERoutingInformation createFrom(@Nonnull TCOutgoingMetadata tCOutgoingMetadata) throws CertificateException {
        ValueEnforcer.notNull((Object)tCOutgoingMetadata, (String)"Metadata");
        return new MERoutingInformation(MERoutingInformationInput.createForInput(tCOutgoingMetadata), tCOutgoingMetadata.getEndpointURL(), CertificateHelper.convertByteArrayToCertficateDirect((byte[])tCOutgoingMetadata.getReceiverCertificate()));
    }
}

