
package eu.toop.connector.api.rest;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * <p>Java class for TCIncomingMetadata complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="TCIncomingMetadata"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="SenderID" type="{urn:eu.toop/toop-connector-ng/2020/05/}TCIdentifierType"/&gt;
 *         &lt;element name="ReceiverID" type="{urn:eu.toop/toop-connector-ng/2020/05/}TCIdentifierType"/&gt;
 *         &lt;element name="DocTypeID" type="{urn:eu.toop/toop-connector-ng/2020/05/}TCIdentifierType"/&gt;
 *         &lt;element name="ProcessID" type="{urn:eu.toop/toop-connector-ng/2020/05/}TCIdentifierType"/&gt;
 *         &lt;element name="PayloadType" type="{urn:eu.toop/toop-connector-ng/2020/05/}TCPayloadType"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TCIncomingMetadata", propOrder = {
    "senderID",
    "receiverID",
    "docTypeID",
    "processID",
    "payloadType"
})
@CodingStyleguideUnaware
public class TCIncomingMetadata implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "SenderID", required = true)
    private TCIdentifierType senderID;
    @XmlElement(name = "ReceiverID", required = true)
    private TCIdentifierType receiverID;
    @XmlElement(name = "DocTypeID", required = true)
    private TCIdentifierType docTypeID;
    @XmlElement(name = "ProcessID", required = true)
    private TCIdentifierType processID;
    @XmlElement(name = "PayloadType", required = true)
    @XmlSchemaType(name = "string")
    private TCPayloadType payloadType;

    /**
     * Gets the value of the senderID property.
     * 
     * @return
     *     possible object is
     *     {@link TCIdentifierType }
     *     
     */
    @Nullable
    public TCIdentifierType getSenderID() {
        return senderID;
    }

    /**
     * Sets the value of the senderID property.
     * 
     * @param value
     *     allowed object is
     *     {@link TCIdentifierType }
     *     
     */
    public void setSenderID(
        @Nullable
        TCIdentifierType value) {
        this.senderID = value;
    }

    /**
     * Gets the value of the receiverID property.
     * 
     * @return
     *     possible object is
     *     {@link TCIdentifierType }
     *     
     */
    @Nullable
    public TCIdentifierType getReceiverID() {
        return receiverID;
    }

    /**
     * Sets the value of the receiverID property.
     * 
     * @param value
     *     allowed object is
     *     {@link TCIdentifierType }
     *     
     */
    public void setReceiverID(
        @Nullable
        TCIdentifierType value) {
        this.receiverID = value;
    }

    /**
     * Gets the value of the docTypeID property.
     * 
     * @return
     *     possible object is
     *     {@link TCIdentifierType }
     *     
     */
    @Nullable
    public TCIdentifierType getDocTypeID() {
        return docTypeID;
    }

    /**
     * Sets the value of the docTypeID property.
     * 
     * @param value
     *     allowed object is
     *     {@link TCIdentifierType }
     *     
     */
    public void setDocTypeID(
        @Nullable
        TCIdentifierType value) {
        this.docTypeID = value;
    }

    /**
     * Gets the value of the processID property.
     * 
     * @return
     *     possible object is
     *     {@link TCIdentifierType }
     *     
     */
    @Nullable
    public TCIdentifierType getProcessID() {
        return processID;
    }

    /**
     * Sets the value of the processID property.
     * 
     * @param value
     *     allowed object is
     *     {@link TCIdentifierType }
     *     
     */
    public void setProcessID(
        @Nullable
        TCIdentifierType value) {
        this.processID = value;
    }

    /**
     * Gets the value of the payloadType property.
     * 
     * @return
     *     possible object is
     *     {@link TCPayloadType }
     *     
     */
    @Nullable
    public TCPayloadType getPayloadType() {
        return payloadType;
    }

    /**
     * Sets the value of the payloadType property.
     * 
     * @param value
     *     allowed object is
     *     {@link TCPayloadType }
     *     
     */
    public void setPayloadType(
        @Nullable
        TCPayloadType value) {
        this.payloadType = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TCIncomingMetadata rhs = ((TCIncomingMetadata) o);
        if (!EqualsHelper.equals(docTypeID, rhs.docTypeID)) {
            return false;
        }
        if (!EqualsHelper.equals(payloadType, rhs.payloadType)) {
            return false;
        }
        if (!EqualsHelper.equals(processID, rhs.processID)) {
            return false;
        }
        if (!EqualsHelper.equals(receiverID, rhs.receiverID)) {
            return false;
        }
        if (!EqualsHelper.equals(senderID, rhs.senderID)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(docTypeID).append(payloadType).append(processID).append(receiverID).append(senderID).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("docTypeID", docTypeID).append("payloadType", payloadType).append("processID", processID).append("receiverID", receiverID).append("senderID", senderID).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TCIncomingMetadata ret) {
        ret.docTypeID = ((docTypeID == null)?null:docTypeID.clone());
        ret.payloadType = payloadType;
        ret.processID = ((processID == null)?null:processID.clone());
        ret.receiverID = ((receiverID == null)?null:receiverID.clone());
        ret.senderID = ((senderID == null)?null:senderID.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TCIncomingMetadata clone() {
        TCIncomingMetadata ret = new TCIncomingMetadata();
        cloneTo(ret);
        return ret;
    }

}
