
package eu.toop.connector.api.rest;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;


/**
 * <p>Java class for TCPayloadType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="TCPayloadType"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *     &lt;enumeration value="Request"/&gt;
 *     &lt;enumeration value="Response"/&gt;
 *     &lt;enumeration value="ErrorResponse"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "TCPayloadType")
@XmlEnum
@CodingStyleguideUnaware
public enum TCPayloadType {

    @XmlEnumValue("Request")
    REQUEST("Request"),
    @XmlEnumValue("Response")
    RESPONSE("Response"),
    @XmlEnumValue("ErrorResponse")
    ERROR_RESPONSE("ErrorResponse");
    private final String value;

    TCPayloadType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static TCPayloadType fromValue(String v) {
        for (TCPayloadType c: TCPayloadType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
