/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.api.me.outgoing;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.rest.TCOutgoingMetadata;
import javax.annotation.Nonnull;

public class MERoutingInformationInput {
    private final IParticipantIdentifier m_aSenderID;
    private final IParticipantIdentifier m_aReceiverID;
    private final IDocumentTypeIdentifier m_aDocTypeID;
    private final IProcessIdentifier m_aProcessID;
    private final String m_sTransportProtocol;

    public MERoutingInformationInput(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IParticipantIdentifier iParticipantIdentifier2, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"SenderID");
        ValueEnforcer.notNull((Object)iParticipantIdentifier2, (String)"ReceiverID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocTypeID");
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcessID");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"TransportProtocol");
        this.m_aSenderID = iParticipantIdentifier;
        this.m_aReceiverID = iParticipantIdentifier2;
        this.m_aDocTypeID = iDocumentTypeIdentifier;
        this.m_aProcessID = iProcessIdentifier;
        this.m_sTransportProtocol = string;
    }

    @Nonnull
    public final IParticipantIdentifier getSenderID() {
        return this.m_aSenderID;
    }

    @Nonnull
    public final IParticipantIdentifier getReceiverID() {
        return this.m_aReceiverID;
    }

    @Nonnull
    public final IDocumentTypeIdentifier getDocumentTypeID() {
        return this.m_aDocTypeID;
    }

    @Nonnull
    public final IProcessIdentifier getProcessID() {
        return this.m_aProcessID;
    }

    @Nonnull
    @Nonempty
    public final String getTransportProtocol() {
        return this.m_sTransportProtocol;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SenderID", (Object)this.m_aSenderID).append("ReceiverID", (Object)this.m_aReceiverID).append("DocTypeID", (Object)this.m_aDocTypeID).append("ProcID", (Object)this.m_aProcessID).append("TransportProtocol", (Object)this.m_sTransportProtocol).getToString();
    }

    @Nonnull
    public static MERoutingInformationInput createForInput(@Nonnull TCOutgoingMetadata tCOutgoingMetadata) {
        ValueEnforcer.notNull((Object)tCOutgoingMetadata, (String)"Metadata");
        IIdentifierFactory iIdentifierFactory = TCConfig.getIdentifierFactory();
        return new MERoutingInformationInput(iIdentifierFactory.createParticipantIdentifier(tCOutgoingMetadata.getSenderID().getScheme(), tCOutgoingMetadata.getSenderID().getValue()), iIdentifierFactory.createParticipantIdentifier(tCOutgoingMetadata.getReceiverID().getScheme(), tCOutgoingMetadata.getReceiverID().getValue()), iIdentifierFactory.createDocumentTypeIdentifier(tCOutgoingMetadata.getDocTypeID().getScheme(), tCOutgoingMetadata.getDocTypeID().getValue()), iIdentifierFactory.createProcessIdentifier(tCOutgoingMetadata.getProcessID().getScheme(), tCOutgoingMetadata.getProcessID().getValue()), tCOutgoingMetadata.getTransportProtocol());
    }
}

