/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.api.me.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.io.ByteArrayWrapper;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.regrep.CRegRep4;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MEPayload
implements Serializable {
    private final IMimeType m_aMimeType;
    private final String m_sContentID;
    private final ByteArrayWrapper m_aData;

    protected MEPayload(@Nonnull IMimeType iMimeType, @Nonnull @Nonempty String string, @Nonnull ByteArrayWrapper byteArrayWrapper) {
        ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ContentID");
        ValueEnforcer.notNull((Object)byteArrayWrapper, (String)"Data");
        this.m_aMimeType = iMimeType;
        this.m_sContentID = string;
        this.m_aData = byteArrayWrapper;
    }

    @Nonnull
    public IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    @Nonnull
    public String getMimeTypeString() {
        return this.m_aMimeType.getAsString();
    }

    @Nonnull
    public String getContentID() {
        return this.m_sContentID;
    }

    @Nonnull
    @ReturnsMutableObject
    public ByteArrayWrapper getData() {
        return this.m_aData;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("MimeType", (Object)this.m_aMimeType).append("ContentID", (Object)this.m_sContentID).append("Data", (Object)this.m_aData).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    @Nonempty
    public static String createRandomContentID() {
        return UUID.randomUUID().toString() + "@tc-ng.toop";
    }

    public static class Builder {
        private IMimeType m_aMimeType;
        private String m_sContentID;
        private ByteArrayWrapper m_aData;

        protected Builder() {
        }

        @Nonnull
        public Builder mimeTypeRegRep() {
            return this.mimeType(CRegRep4.MIME_TYPE_EBRS_XML);
        }

        @Nonnull
        public Builder mimeType(@Nullable IMimeType iMimeType) {
            this.m_aMimeType = iMimeType;
            return this;
        }

        @Nonnull
        public Builder randomContentID() {
            return this.contentID(MEPayload.createRandomContentID());
        }

        @Nonnull
        public Builder contentID(@Nullable String string) {
            this.m_sContentID = string;
            return this;
        }

        @Nonnull
        public Builder data(@Nullable byte[] byArray) {
            return this.data(byArray == null ? null : new ByteArrayWrapper(byArray, false));
        }

        @Nonnull
        public Builder data(@Nullable String string, @Nonnull Charset charset) {
            return this.data(string == null ? null : ByteArrayWrapper.create((String)string, (Charset)charset));
        }

        @Nonnull
        public Builder data(@Nullable ByteArrayWrapper byteArrayWrapper) {
            this.m_aData = byteArrayWrapper;
            return this;
        }

        public void checkConsistency() {
            if (this.m_aMimeType == null) {
                throw new IllegalStateException("MimeType MUST be present");
            }
            if (StringHelper.hasNoText((String)this.m_sContentID)) {
                throw new IllegalStateException("Content ID MUST be present");
            }
            if (this.m_aData == null) {
                throw new IllegalStateException("Data MUST be present");
            }
        }

        @Nonnull
        public MEPayload build() {
            this.checkConsistency();
            return new MEPayload(this.m_aMimeType, this.m_sContentID, this.m_aData);
        }
    }
}

