/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.api.me.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import eu.toop.connector.api.me.model.MEPayload;
import java.io.Serializable;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MEMessage
implements Serializable {
    private final ICommonsList<MEPayload> m_aPayloads = new CommonsArrayList();

    protected MEMessage(@Nonnull @Nonempty ICommonsList<MEPayload> iCommonsList) {
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, (String)"Payloads");
        this.m_aPayloads.addAll(iCommonsList);
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableObject
    public ICommonsList<MEPayload> payloads() {
        return this.m_aPayloads;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<MEPayload> getAllPayloads() {
        return (ICommonsList)this.m_aPayloads.getClone();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ICommonsList<MEPayload> m_aPayloads = new CommonsArrayList();

        protected Builder() {
        }

        @Nonnull
        public Builder addPayload(@Nullable Consumer<? super MEPayload.Builder> consumer) {
            if (consumer != null) {
                MEPayload.Builder builder = MEPayload.builder();
                consumer.accept(builder);
                this.addPayload(builder);
            }
            return this;
        }

        @Nonnull
        public Builder addPayload(@Nullable MEPayload.Builder builder) {
            return this.addPayload(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder addPayload(@Nullable MEPayload mEPayload) {
            if (mEPayload != null) {
                this.m_aPayloads.add((Object)mEPayload);
            }
            return this;
        }

        @Nonnull
        public Builder payload(@Nullable Consumer<? super MEPayload.Builder> consumer) {
            if (consumer != null) {
                MEPayload.Builder builder = MEPayload.builder();
                consumer.accept(builder);
                this.payload(builder);
            }
            return this;
        }

        @Nonnull
        public Builder payload(@Nullable MEPayload.Builder builder) {
            return this.payload(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder payload(@Nullable MEPayload mEPayload) {
            if (mEPayload != null) {
                this.m_aPayloads.set((Object)mEPayload);
            } else {
                this.m_aPayloads.clear();
            }
            return this;
        }

        @Nonnull
        public Builder payloads(MEPayload ... mEPayloadArray) {
            this.m_aPayloads.setAll((Object[])mEPayloadArray);
            return this;
        }

        @Nonnull
        public Builder payloads(@Nullable Iterable<MEPayload> iterable) {
            this.m_aPayloads.setAll(iterable);
            return this;
        }

        public void checkConsistency() {
            if (this.m_aPayloads.isEmpty()) {
                throw new IllegalStateException("At least one payload MUST be present");
            }
        }

        @Nonnull
        public MEMessage build() {
            this.checkConsistency();
            return new MEMessage(this.m_aPayloads);
        }
    }
}

