/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.api.me.incoming;

import com.helger.commons.string.ToStringGenerator;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.me.incoming.IMEIncomingTransportMetadata;
import eu.toop.connector.api.rest.TCIncomingMetadata;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MEIncomingTransportMetadata
implements IMEIncomingTransportMetadata {
    private final IParticipantIdentifier m_aSenderID;
    private final IParticipantIdentifier m_aReceiverID;
    private final IDocumentTypeIdentifier m_aDocTypeID;
    private final IProcessIdentifier m_aProcessID;

    public MEIncomingTransportMetadata(@Nullable IParticipantIdentifier iParticipantIdentifier, @Nullable IParticipantIdentifier iParticipantIdentifier2, @Nullable IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nullable IProcessIdentifier iProcessIdentifier) {
        this.m_aSenderID = iParticipantIdentifier;
        this.m_aReceiverID = iParticipantIdentifier2;
        this.m_aDocTypeID = iDocumentTypeIdentifier;
        this.m_aProcessID = iProcessIdentifier;
    }

    @Override
    @Nullable
    public IParticipantIdentifier getSenderID() {
        return this.m_aSenderID;
    }

    @Override
    @Nullable
    public IParticipantIdentifier getReceiverID() {
        return this.m_aReceiverID;
    }

    @Override
    @Nullable
    public IDocumentTypeIdentifier getDocumentTypeID() {
        return this.m_aDocTypeID;
    }

    @Override
    @Nullable
    public IProcessIdentifier getProcessID() {
        return this.m_aProcessID;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SenderID", (Object)this.m_aSenderID).append("ReceiverID", (Object)this.m_aReceiverID).append("DocTypeID", (Object)this.m_aDocTypeID).append("ProcID", (Object)this.m_aProcessID).getToString();
    }

    @Nonnull
    public static MEIncomingTransportMetadata create(@Nonnull TCIncomingMetadata tCIncomingMetadata) {
        IIdentifierFactory iIdentifierFactory = TCConfig.getIdentifierFactory();
        IParticipantIdentifier iParticipantIdentifier = iIdentifierFactory.createParticipantIdentifier(tCIncomingMetadata.getSenderID().getScheme(), tCIncomingMetadata.getSenderID().getValue());
        IParticipantIdentifier iParticipantIdentifier2 = iIdentifierFactory.createParticipantIdentifier(tCIncomingMetadata.getReceiverID().getScheme(), tCIncomingMetadata.getReceiverID().getValue());
        IDocumentTypeIdentifier iDocumentTypeIdentifier = iIdentifierFactory.createDocumentTypeIdentifier(tCIncomingMetadata.getDocTypeID().getScheme(), tCIncomingMetadata.getDocTypeID().getValue());
        IProcessIdentifier iProcessIdentifier = iIdentifierFactory.createProcessIdentifier(tCIncomingMetadata.getProcessID().getScheme(), tCIncomingMetadata.getProcessID().getValue());
        return new MEIncomingTransportMetadata(iParticipantIdentifier, iParticipantIdentifier2, iDocumentTypeIdentifier, iProcessIdentifier);
    }
}

