/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.api.me.incoming;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.connector.api.me.incoming.IIncomingEDMResponse;
import eu.toop.connector.api.me.incoming.IMEIncomingTransportMetadata;
import eu.toop.connector.api.me.model.MEPayload;
import eu.toop.edm.EDMResponse;
import javax.annotation.Nonnull;

public class IncomingEDMResponse
implements IIncomingEDMResponse {
    private final EDMResponse m_aResponse;
    private final ICommonsOrderedMap<String, MEPayload> m_aAttachments = new CommonsLinkedHashMap();
    private final IMEIncomingTransportMetadata m_aMetadata;

    public IncomingEDMResponse(@Nonnull EDMResponse eDMResponse, @Nonnull ICommonsList<MEPayload> iCommonsList, @Nonnull IMEIncomingTransportMetadata iMEIncomingTransportMetadata) {
        ValueEnforcer.notNull((Object)eDMResponse, (String)"Response");
        ValueEnforcer.notNullNoNullValue(iCommonsList, (String)"Attachments");
        ValueEnforcer.notNull((Object)iMEIncomingTransportMetadata, (String)"Metadata");
        this.m_aResponse = eDMResponse;
        for (MEPayload mEPayload : iCommonsList) {
            this.m_aAttachments.put((Object)mEPayload.getContentID(), (Object)mEPayload);
        }
        this.m_aMetadata = iMEIncomingTransportMetadata;
    }

    @Nonnull
    public EDMResponse getResponse() {
        return this.m_aResponse;
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsOrderedMap<String, MEPayload> attachments() {
        return this.m_aAttachments;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, MEPayload> getAllAttachments() {
        return this.m_aAttachments.getClone();
    }

    @Override
    @Nonnull
    public IMEIncomingTransportMetadata getMetadata() {
        return this.m_aMetadata;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Response", (Object)this.m_aResponse).append("Attachments", this.m_aAttachments).append("Metadata", (Object)this.m_aMetadata).getToString();
    }
}

