/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.api.dd;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppolid.IParticipantIdentifier;
import eu.toop.connector.api.dd.IDDEndpoint;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public class DDEndpoint
implements IDDEndpoint {
    private final IParticipantIdentifier m_aParticipantID;
    private final String m_sTransportProtocol;
    private final String m_sEndpointURL;
    private final X509Certificate m_aCert;

    public DDEndpoint(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull X509Certificate x509Certificate) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"TransportProtocol");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"EndpointURL");
        ValueEnforcer.notNull((Object)x509Certificate, (String)"Cert");
        this.m_aParticipantID = iParticipantIdentifier;
        this.m_sTransportProtocol = string;
        this.m_sEndpointURL = string2;
        this.m_aCert = x509Certificate;
    }

    @Override
    @Nonnull
    public IParticipantIdentifier getParticipantID() {
        return this.m_aParticipantID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getTransportProtocol() {
        return this.m_sTransportProtocol;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getEndpointURL() {
        return this.m_sEndpointURL;
    }

    @Override
    @Nonnull
    public X509Certificate getCertificate() {
        return this.m_aCert;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DDEndpoint dDEndpoint = (DDEndpoint)object;
        return this.m_aParticipantID.equals(dDEndpoint.m_aParticipantID) && this.m_sTransportProtocol.equals(dDEndpoint.m_sTransportProtocol) && this.m_sEndpointURL.equals(dDEndpoint.m_sEndpointURL) && this.m_aCert.equals(dDEndpoint.m_aCert);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aParticipantID).append((Object)this.m_sTransportProtocol).append((Object)this.m_sEndpointURL).append((Object)this.m_aCert).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ParticipantID", (Object)this.m_aParticipantID).append("TransportProtocol", (Object)this.m_sTransportProtocol).append("EndpointURL", (Object)this.m_sEndpointURL).append("Cert", (Object)this.m_aCert).getToString();
    }
}

