/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.roa.service;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.pd.searchapi.v1.ResultListType;
import eu.toop.dsd.api.DsdResponseWriter;
import eu.toop.dsd.api.ToopDirClient;
import eu.toop.roa.config.ROAConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ROAQueryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ROAQueryService.class);
    public static final String QUERY_DATASET_REQUEST = "urn:toop:roa:ebxml-regrep:queries:DataConsumerByProcedure";
    public static final String PARAM_NAME_DATA_CONSUMER_ID = "DataConsumerId";
    public static final String PARAM_NAME_QUERY_ID = "queryId";
    public static final String PARAM_NAME_PROCEDURE_ID = "procedureId";

    public static void processRequest(@Nonnull @Nonempty Map<String, String[]> map, @Nonnull OutputStream outputStream) {
        ValueEnforcer.notNull(map, (String)"parameterMap");
        ValueEnforcer.notNull((Object)outputStream, (String)"responseStream");
        if (map.isEmpty()) {
            throw new IllegalArgumentException("parameterMap cannot be empty");
        }
        Object[] objectArray = map.get("queryId");
        ValueEnforcer.notEmpty((Object[])objectArray, (String)"queryId");
        if (objectArray.length != 1) {
            throw new IllegalStateException("queryId invalid");
        }
        Object object = objectArray[0];
        LOGGER.debug("Processing query: [QueryId: " + (String)object + "");
        switch (object) {
            case "urn:toop:roa:ebxml-regrep:queries:DataConsumerByProcedure": {
                try {
                    ROAQueryService.processDataSetRequest(map, (OutputStream)outputStream);
                    break;
                }
                catch (IOException iOException) {
                    throw new IllegalStateException(iOException.getMessage(), iOException);
                }
            }
            default: {
                throw new IllegalArgumentException("Invalid queryId " + objectArray);
            }
        }
    }

    public static void processDataSetRequest(@Nonnull @Nonempty Map<String, String[]> map, @Nonnull OutputStream outputStream) throws IOException {
        ValueEnforcer.notNull(map, (String)"parameterMap");
        ValueEnforcer.notNull((Object)outputStream, (String)"responseStream");
        if (map.isEmpty()) {
            throw new IllegalArgumentException("parameterMap cannot be empty");
        }
        String string = null;
        Object[] objectArray = map.get("DataConsumerId");
        ValueEnforcer.notEmpty((Object[])objectArray, (String)"dataConsumerId");
        if (objectArray.length != 1) {
            throw new IllegalStateException("DataConsumerId invalid");
        }
        Object object = objectArray[0];
        String[] stringArray = map.get("procedureId");
        if (stringArray != null) {
            if (stringArray.length != 1) {
                throw new IllegalStateException("procedureId invalid");
            }
            string = stringArray[0];
        }
        LOGGER.debug("Processing data consumer request [data consumer id: " + (String)object + ", procedureId: " + string + "]");
        ResultListType resultListType = ToopDirClient.callSearchApi((String)ROAConfig.getToopDirUrl(), (String)string, null);
        List list = resultListType.getMatch();
        StringWriter stringWriter = new StringWriter();
        DsdResponseWriter.matchTypesWriter((String)object, (List)list).write((Writer)stringWriter);
        String string2 = stringWriter.toString();
        outputStream.write(string2.getBytes(StandardCharsets.UTF_8));
    }
}

