/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.roa.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ROAConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ROAConfig.class);
    private static final String toopDirUrl;
    private static final String roaVersion;
    private static final String buildDate;
    private static final String ROA_CONFIG_RESOURCE_NAME = "/roa-config.conf";

    public static String getToopDirUrl() {
        return toopDirUrl;
    }

    public static String getRoaVersion() {
        return roaVersion;
    }

    public static String getBuildDate() {
        return buildDate;
    }

    static {
        String string = "roa-config.conf";
        LOGGER.info("Loading config from the \"" + string);
        Config config = ConfigFactory.parseURL((URL)ROAConfig.class.getResource(ROA_CONFIG_RESOURCE_NAME)).withFallback((ConfigMergeable)ConfigFactory.systemProperties()).resolve();
        toopDirUrl = config.getString("roa.toop-dir-url");
        roaVersion = config.getString("roa.version");
        buildDate = config.getString("roa.buildDate");
        LOGGER.info("--------- RUNNING ROA-" + roaVersion + " ---------");
        LOGGER.debug("toopDirUrl: " + toopDirUrl);
    }
}

