/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.roa.servlet;

import eu.toop.roa.service.ROAQueryService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/rest/search"})
public class ROARestQueryServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ROARestQueryServlet.class);

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        LOGGER.debug("ROA query  with " + httpServletRequest.getQueryString());
        try {
            Map map = httpServletRequest.getParameterMap();
            ROAQueryService.processRequest(map, (OutputStream)httpServletResponse.getOutputStream());
            httpServletResponse.setContentType("application/xml");
        }
        catch (Exception exception) {
            httpServletResponse.setContentType("text/plain");
            LOGGER.error(exception.getMessage(), (Throwable)exception);
            if (exception instanceof IllegalStateException) {
                httpServletResponse.setStatus(400);
            } else {
                httpServletResponse.setStatus(500);
            }
            String string = exception.getMessage();
            httpServletResponse.getOutputStream().println(string != null ? string : "UNKNOWN ERROR");
        }
    }
}

