/*
 * Decompiled with CFR 0.152.
 */
package eu.toennies.javahttpobservatoryapi.commands;

import eu.toennies.javahttpobservatoryapi.Api;
import eu.toennies.javahttpobservatoryapi.ConsoleUtilities;
import eu.toennies.javahttpobservatoryapi.commands.ApiCommand;
import eu.toennies.javahttpobservatoryapi.commands.CommandArgument;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class InvokeAssessmentCommand
extends ApiCommand {
    public InvokeAssessmentCommand() {
        super("analyze", "retrieveAssessment", "ia", "Invoke assessment", "Used to invoke a new scan of a website. By default, the HTTP Observatory will return a cached site result if the site has been scanned anytime in the previous 24 hours.");
        CommandArgument param1 = new CommandArgument("host", "hostname to scan", true);
        super.addCommandArgument(param1);
        CommandArgument param2 = new CommandArgument("rescan", "true if a fresh scan should be performed", false);
        super.addCommandArgument(param2);
        CommandArgument param3 = new CommandArgument("hidden", "true if the result should not show up in the getRecenScan call", false);
        super.addCommandArgument(param3);
    }

    @Override
    public JSONObject run(List<String> arguments) throws IllegalArgumentException {
        if (arguments == null || ConsoleUtilities.listValueMatchRegex(arguments, "host=(.+)") == null) {
            throw new IllegalArgumentException("The mandatory argument host is not given.");
        }
        JSONObject json = null;
        try {
            Api api = new Api();
            HashMap<String, String> postParameters = new HashMap<String, String>();
            postParameters.put("rescan", arguments.contains("rescan") ? "true" : "false");
            postParameters.put("hidden", arguments.contains("hidden") ? "true" : "false");
            String host = ConsoleUtilities.listValueMatchRegex(arguments, "host=(.+)");
            String commandUrl = this.getApiCommand() + "?host=" + host;
            json = new JSONObject(api.sendApiPostRequest(commandUrl, postParameters));
            this.checkForError(json);
        }
        catch (JSONException e) {
            Logger.getGlobal().severe("Could not build result: " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            Logger.getGlobal().severe("Could not send API request: " + e.getLocalizedMessage());
        }
        return json;
    }

    private void checkForError(JSONObject json) throws IOException, JSONException {
        String error;
        if (json.has("error") && "rescan-attempt-too-soon".equals(error = json.getString("error"))) {
            throw new IOException("A resacan attempt to soon. Try calling without \"rescan\" or wait 5 minutes.");
        }
    }
}

