/*
 * Decompiled with CFR 0.152.
 */
package eu.toennies.javahttpobservatoryapi.commands;

import eu.toennies.javahttpobservatoryapi.Api;
import eu.toennies.javahttpobservatoryapi.commands.CommandArgument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ApiCommand {
    public static final String DEFAULT_CMD_PREFIX = "-";
    public static final String DEFAULT_LONG_CMD_PREFIX = "--";
    private final String apiCommand;
    private String consoleCommand;
    private String consoleShortCommand;
    private String header;
    private String description;
    private List<CommandArgument> commandArguments = new ArrayList<CommandArgument>();

    public ApiCommand(String apiCommand, String console, String consoleShort, String header, String description) {
        this.apiCommand = apiCommand;
        this.consoleCommand = console;
        this.consoleShortCommand = consoleShort;
        this.description = description;
        this.header = header;
    }

    public abstract JSONObject run(List<String> var1) throws IllegalArgumentException;

    public String getApiCommand() {
        return this.apiCommand;
    }

    public String getConsoleCommand() {
        return DEFAULT_LONG_CMD_PREFIX + this.consoleCommand;
    }

    public String getConsoleShortCommand() {
        return DEFAULT_CMD_PREFIX + this.consoleShortCommand;
    }

    public JSONObject callApiCommand() {
        return this.callApiCommand(null);
    }

    public String getDescription() {
        return this.description;
    }

    public String getHeader() {
        return this.header;
    }

    public JSONObject callApiCommand(Map<String, String> parameters) {
        JSONObject apiInfo = null;
        try {
            Api api = new Api();
            apiInfo = new JSONObject(api.sendApiGetRequest(this.getApiCommand(), parameters));
        }
        catch (JSONException e) {
            Logger.getGlobal().severe("Could not build result: " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            Logger.getGlobal().severe("Could not send API request: " + e.getLocalizedMessage());
        }
        return apiInfo;
    }

    public String getHelp() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getConsoleShortCommand());
        buffer.append(", ");
        buffer.append(this.getConsoleCommand());
        buffer.append("    ");
        buffer.append(this.getDescription());
        return buffer.toString();
    }

    public List<CommandArgument> getCommandArguments() {
        return this.commandArguments;
    }

    public void addCommandArgument(CommandArgument param) {
        this.commandArguments.add(param);
    }

    public boolean hasArgs() {
        return !this.commandArguments.isEmpty();
    }

    public boolean shouldStart(List<String> arguments) {
        return arguments.contains(this.getConsoleCommand()) || arguments.contains(this.getConsoleShortCommand());
    }
}

