/*
 * Decompiled with CFR 0.152.
 */
package eu.toennies.javahttpobservatoryapi;

import eu.toennies.javahttpobservatoryapi.Api;
import eu.toennies.javahttpobservatoryapi.commands.ApiCommand;
import eu.toennies.javahttpobservatoryapi.commands.ApiCommands;
import eu.toennies.javahttpobservatoryapi.commands.CommandArgument;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class HelpFormatter {
    private static final int DEFAULT_WIDTH = 105;
    private static final int DEFAULT_LEFT_PAD = 1;
    private static final int DEFAULT_DESC_PAD = 3;
    public static final String DEFAULT_SYNTAX_PREFIX = "usage: ";
    private String newLine = System.getProperty("line.separator");
    private int width = 105;
    private int leftPad = 1;
    private int descPad = 3;
    private String syntaxPrefix = "usage: ";
    private PrintWriter pw;

    public HelpFormatter(PrintWriter pw) {
        this.pw = pw;
    }

    public String getNewLine() {
        return this.newLine;
    }

    public void setNewLine(String defaultNewLine) {
        this.newLine = defaultNewLine;
    }

    public String getSyntaxPrefix() {
        return this.syntaxPrefix;
    }

    public void setSyntaxPrefix(String syntaxPrefix) {
        this.syntaxPrefix = syntaxPrefix;
    }

    public int getLeftPadding() {
        return this.leftPad;
    }

    public int getDescPadding() {
        return this.descPad;
    }

    public void setLeftPadding(int leftPad) {
        this.leftPad = leftPad;
    }

    public void setDescPadding(int defaultDescPad) {
        this.descPad = defaultDescPad;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void printHelp(ApiCommands[] commands) {
        String jarName = "java-http-observatory-api-" + Api.getVersion() + ".jar";
        String jarExecution = "java -jar " + jarName;
        String footer = "If you need to use a proxy, please create a file called \"proxy\" in program directory and fill with one line containing proxy ip:port";
        this.printHelp(this.getWidth(), jarExecution, this.getHeader(), commands, footer);
    }

    public void printHelp(int width, String cmdLineSyntax, String header, ApiCommands[] commands, String footer) {
        this.printHelp(width, cmdLineSyntax, header, commands, this.getLeftPadding(), this.getDescPadding(), footer);
        this.pw.flush();
    }

    public void printHelp(int width, String cmdLineSyntax, String header, ApiCommands[] commands, int leftPad, int descPad, String footer) {
        if (cmdLineSyntax == null || cmdLineSyntax.length() == 0) {
            throw new IllegalArgumentException("cmdLineSyntax not provided");
        }
        if (header != null && header.trim().length() > 0) {
            this.pw.print(header);
        }
        this.printUsage(width, cmdLineSyntax);
        this.printOptions(width, commands, leftPad, descPad);
        if (footer != null && footer.trim().length() > 0) {
            this.pw.print("\n");
            this.printWrapped(width, footer);
        }
    }

    public void printUsage(int width, String cmdLineSyntax) {
        int argPos = cmdLineSyntax.indexOf(32) + 1;
        this.printWrapped(this.pw, width, this.getSyntaxPrefix().length() + argPos, this.getSyntaxPrefix() + cmdLineSyntax);
    }

    public void printWrapped(PrintWriter pw, int width, int nextLineTabStop, String text) {
        StringBuffer sb = new StringBuffer(text.length());
        this.renderWrappedTextBlock(sb, width, nextLineTabStop, text);
        pw.println(sb.toString());
    }

    private Appendable renderWrappedTextBlock(StringBuffer sb, int width, int nextLineTabStop, String text) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new StringReader(text));
            boolean firstLine = true;
            while ((line = in.readLine()) != null) {
                if (!firstLine) {
                    sb.append(this.getNewLine());
                } else {
                    firstLine = false;
                }
                this.renderWrappedText(sb, width, nextLineTabStop, line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb;
    }

    protected StringBuffer renderWrappedText(StringBuffer sb, int width, int nextLineTabStop, String text) {
        int pos = this.findWrapPos(text, width, 0);
        if (pos == -1) {
            sb.append(this.rtrim(text));
            return sb;
        }
        sb.append(this.rtrim(text.substring(0, pos))).append(this.getNewLine());
        int currentNextLineTabStop = nextLineTabStop >= width ? 1 : nextLineTabStop;
        String padding = this.createPadding(currentNextLineTabStop);
        String newText = text;
        while (true) {
            if ((pos = this.findWrapPos(newText = padding + newText.substring(pos).trim(), width, 0)) == -1) {
                sb.append(newText);
                return sb;
            }
            if (newText.length() > width && pos == currentNextLineTabStop - 1) {
                pos = width;
            }
            sb.append(this.rtrim(newText.substring(0, pos))).append(this.getNewLine());
        }
    }

    protected int findWrapPos(String text, int width, int startPos) {
        char c;
        int pos = text.indexOf(10, startPos);
        if (pos != -1 && pos <= width) {
            return pos + 1;
        }
        pos = text.indexOf(9, startPos);
        if (pos != -1 && pos <= width) {
            return pos + 1;
        }
        if (startPos + width >= text.length()) {
            return -1;
        }
        for (pos = startPos + width; pos >= startPos && (c = text.charAt(pos)) != ' ' && c != '\n' && c != '\r'; --pos) {
        }
        if (pos > startPos) {
            return pos;
        }
        pos = startPos + width;
        return pos == text.length() ? -1 : pos;
    }

    protected String rtrim(String s) {
        int pos;
        if (s == null || s.length() == 0) {
            return s;
        }
        for (pos = s.length(); pos > 0 && Character.isWhitespace(s.charAt(pos - 1)); --pos) {
        }
        return s.substring(0, pos);
    }

    protected String createPadding(int len) {
        char[] padding = new char[len];
        Arrays.fill(padding, ' ');
        return new String(padding);
    }

    public void printWrapped(int width, String text) {
        this.printWrapped(this.pw, width, 0, text);
    }

    public String getHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("     _                   ____  _                              _                            _____ _____ ");
        sb.append("\n");
        sb.append("    | |                 / __ \\| |                            | |                     /\\   |  __ \\_   _|");
        sb.append("\n");
        sb.append("    | | __ ___   ____ _| |  | | |__  ___  ___ _ ____   ____ _| |_ ___  _ __ _   _   /  \\  | |__) || |  ");
        sb.append("\n");
        sb.append("_   | |/ _` \\ \\ / / _` | |  | | '_ \\/ __|/ _ \\ '__\\ \\ / / _` | __/ _ \\| '__| | | | / /\\ \\ |  ___/ | |  ");
        sb.append("\n");
        sb.append(" |__| | (_| |\\ V / (_| | |__| | |_) \\__ \\  __/ |   \\ V / (_| | || (_) | |  | |_| |/ ____ \\| |    _| |_ ");
        sb.append("\n");
        sb.append("\\____/ \\__,_| \\_/ \\__,_|\\____/|_.__/|___/\\___|_|    \\_/ \\__,_|\\__\\___/|_|   \\__, /_/    \\_\\_|   |_____|");
        sb.append("\n");
        sb.append("by Sascha Toennies  <https://github.com/stoennies>");
        sb.append("\n");
        sb.append("and contributors (https://github.com/stoennies/java-http-observatory-api/graphs/contributors)");
        sb.append("\n");
        sb.append("-------------------------------------------------------------------------------------------------------");
        sb.append("\n");
        return sb.toString();
    }

    public void printOptions(int width, ApiCommands[] commands, int leftPad, int descPad) {
        StringBuffer sb = new StringBuffer();
        this.renderCommands(sb, width, commands, leftPad, descPad);
        this.pw.println(sb.toString());
    }

    protected StringBuffer renderCommands(StringBuffer sb, int width, ApiCommands[] commands, int leftPad, int descPad) {
        String lpad = this.createPadding(leftPad);
        String dpad = this.createPadding(descPad);
        int max = 0;
        ArrayList<StringBuffer> prefixList = new ArrayList<StringBuffer>();
        for (ApiCommands cmds : commands) {
            ApiCommand command = cmds.getCommand();
            StringBuffer optBuf = new StringBuffer();
            optBuf.append(lpad).append(command.getConsoleShortCommand());
            optBuf.append(", ").append(command.getConsoleCommand());
            if (command.hasArgs()) {
                this.renderArgs(optBuf, command);
            }
            prefixList.add(optBuf);
            max = optBuf.length() > max ? optBuf.length() : max;
        }
        int x = 0;
        Iterator<ApiCommands> it = Arrays.asList(commands).iterator();
        while (it.hasNext()) {
            StringBuilder opt2Buf;
            ApiCommands option = it.next();
            if ((opt2Buf = new StringBuilder(((StringBuffer)prefixList.get(x++)).toString())).length() < max) {
                opt2Buf.append(this.createPadding(max - opt2Buf.length()));
            }
            opt2Buf.append(dpad);
            int nextLineTabStop = max + descPad;
            if (option.getCommand().getDescription() != null) {
                opt2Buf.append(option.getCommand().getDescription());
            }
            this.renderWrappedText(sb, width, nextLineTabStop, opt2Buf.toString());
            if (!it.hasNext()) continue;
            sb.append(this.getNewLine());
        }
        return sb;
    }

    private void renderArgs(StringBuffer optBuf, ApiCommand command) {
        for (CommandArgument arg : command.getCommandArguments()) {
            String argName = arg.getKey();
            if (argName != null && argName.length() == 0) {
                optBuf.append(' ');
                continue;
            }
            optBuf.append(" ");
            optBuf.append("<").append(argName).append("=value>");
        }
    }
}

