/*
 * Decompiled with CFR 0.152.
 */
package eu.toennies.javahttpobservatoryapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConsoleUtilities {
    private static String newLine = "\n";

    public static Map<String, Object> jsonToMap(JSONObject json) throws JSONException {
        Map<String, Object> retMap = new HashMap<String, Object>();
        if (json != null) {
            retMap = ConsoleUtilities.toMap(json);
        }
        return retMap;
    }

    public static Map<String, Object> toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keysItr = object.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            List<Object> value = object.get(key);
            if (value instanceof JSONArray) {
                value = ConsoleUtilities.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = ConsoleUtilities.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    public static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = ConsoleUtilities.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = ConsoleUtilities.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    public static String mapToConsoleOutput(Map<String, Object> map) {
        StringBuffer consoleOutput = new StringBuffer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            consoleOutput.append(entry.getKey());
            consoleOutput.append(" = ");
            consoleOutput.append(entry.getValue().toString());
            consoleOutput.append(newLine);
        }
        return consoleOutput.toString();
    }

    public static String arrayValueMatchRegex(String[] array, String regex) {
        Pattern p = Pattern.compile(regex);
        for (int i = 0; i < array.length; ++i) {
            Matcher m = p.matcher(array[i]);
            while (m.find()) {
                if (m.groupCount() == 0) {
                    return m.group();
                }
                if (m.groupCount() != 1) continue;
                return m.group(1);
            }
        }
        return null;
    }

    public static String listValueMatchRegex(List<String> arguments, String regex) {
        Pattern p = Pattern.compile(regex);
        for (String arg : arguments) {
            Matcher m = p.matcher(arg);
            while (m.find()) {
                if (m.groupCount() == 0) {
                    return m.group();
                }
                if (m.groupCount() != 1) continue;
                return m.group(1);
            }
        }
        return null;
    }
}

