/*
 * Decompiled with CFR 0.152.
 */
package eu.toennies.javahttpobservatoryapi;

import eu.toennies.javahttpobservatoryapi.ConsoleUtilities;
import eu.toennies.javahttpobservatoryapi.HelpFormatter;
import eu.toennies.javahttpobservatoryapi.commands.ApiCommand;
import eu.toennies.javahttpobservatoryapi.commands.ApiCommands;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class Console {
    private String proxy = null;

    public String getProxy() {
        return this.proxy;
    }

    private Console() {
        this.configureProxy();
    }

    public static Console getInstance() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        List<String> arguments = Arrays.asList(args);
        if (arguments.contains("-h") || arguments.contains("--help")) {
            Console.printHelp();
            return;
        }
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
            for (ApiCommands cmds : ApiCommands.values()) {
                ApiCommand cmd = cmds.getCommand();
                if (!cmd.shouldStart(arguments)) continue;
                try {
                    JSONObject json = cmd.run(arguments);
                    pw.println(cmd.getHeader());
                    pw.println("");
                    pw.println(ConsoleUtilities.mapToConsoleOutput(ConsoleUtilities.jsonToMap(json)));
                    pw.flush();
                }
                catch (JSONException e) {
                    System.err.println("Could not pars API response: " + e.getLocalizedMessage());
                }
                catch (IllegalArgumentException ia) {
                    System.err.println(ia.getLocalizedMessage());
                }
            }
        }
    }

    private static void printHelp() {
        try {
            HelpFormatter hf = new HelpFormatter(new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8")));
            hf.printHelp(ApiCommands.values());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void configureProxy() {
        File file = new File("proxy");
        if (!file.exists()) {
            return;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String proxy = reader.readLine();
            if (proxy != null) {
                this.proxy = proxy;
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            Logger.getGlobal().severe(e.getLocalizedMessage());
        }
        catch (IOException e) {
            Logger.getGlobal().severe(e.getLocalizedMessage());
        }
    }

    private static class Holder {
        private static final Console INSTANCE = new Console();

        private Holder() {
        }
    }
}

