package eu.tneitzel.rmg.endpoints;

import java.util.List;

/**
 * The Vulnerability class represents a known vulnerability of a KnownEndpoint. This is used
 * to make the user aware of attack vectors that exist and should be checked on the KnownEndpoint.
 * A KnownEndpoint can contain multiple vulnerabilities that are displayed when using
 * remote-method-guesser's 'known' action.
 *
 * @author Tobias Neitzel (@qtc_de)
 */
public class Vulnerability
{
    private String name;
    private String description;

    private List<String> references;

    /**
     * Set vulnerability name
     *
     * @param name of the vulnerability
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * Set the description of the vulnerability.
     *
     * @param description vulnerability description
     */
    public void setDescription(String description)
    {
        this.description = description;
    }

    /**
     * Set the references of the vulnerability.
     *
     * @param references vulnerability references
     */
    public void setReferences(List<String> references)
    {
        this.references = references;
    }

    /**
     * Get the vulnerability name.
     *
     * @return name
     */
    public String getName()
    {
        return name;
    }

    /**
     * Get the vulnerability description.
     *
     * @return description
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * Get the vulnerability references.
     *
     * @return references
     */
    public List<String> getReferences()
    {
        return references;
    }
}
