/*
 * Decompiled with CFR 0.152.
 */
package eu.timepit.fs2cron.calev;

import cats.FlatMap;
import cats.Functor;
import cats.Semigroupal;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Sync;
import cats.syntax.package;
import com.github.eikek.calev.CalEvent;
import eu.timepit.fs2cron.Scheduler;
import fs2.Stream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration$;
import scala.runtime.LambdaDeserialize;

public final class CalevScheduler$ {
    public static final CalevScheduler$ MODULE$ = new CalevScheduler$();

    public <F> Scheduler<F, CalEvent> systemDefault(GenTemporal<F, Throwable> temporal, Sync<F> F) {
        return this.from(F.delay((Function0 & Serializable)() -> ZoneId.systemDefault()), temporal);
    }

    public <F> Scheduler<F, CalEvent> utc(GenTemporal<F, Throwable> F) {
        return this.from(F.pure((Object)ZoneOffset.UTC), F);
    }

    public <F> Scheduler<F, CalEvent> from(F zoneId, GenTemporal<F, Throwable> F) {
        return new Scheduler<F, CalEvent>(F, zoneId){
            private final F now;
            private volatile boolean bitmap$init$0;
            private final GenTemporal F$1;

            public final Object sleepUntilNext(Object schedule) {
                return Scheduler.sleepUntilNext$((Scheduler)this, (Object)schedule);
            }

            public final Stream sleep(Object schedule) {
                return Scheduler.sleep$((Scheduler)this, (Object)schedule);
            }

            public final Stream awakeEvery(Object schedule) {
                return Scheduler.awakeEvery$((Scheduler)this, (Object)schedule);
            }

            public final <A> Stream<F, A> schedule(List<Tuple2<CalEvent, Stream<F, A>>> tasks) {
                return Scheduler.schedule$((Scheduler)this, tasks);
            }

            public F fromNowUntilNext(CalEvent schedule) {
                return (F)package.all$.MODULE$.toFlatMapOps(this.now(), (FlatMap)this.F$1).flatMap((Function1 & Serializable)from -> {
                    Object object;
                    Option option = schedule.nextElapse(from);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        ZonedDateTime next = (ZonedDateTime)some.value();
                        long durationInMillis = from.until(next, ChronoUnit.MILLIS);
                        object = $this.F$1.pure((Object)FiniteDuration$.MODULE$.apply(durationInMillis, TimeUnit.MILLISECONDS));
                    } else if (None$.MODULE$.equals(option)) {
                        String msg = new StringBuilder(0).append(new StringBuilder(45).append("Could not calculate the next date-time from ").append(from).append(" ").toString()).append(new StringBuilder(65).append("given the calendar event expression '").append(schedule.asString()).append("'. This should never happen.").toString()).toString();
                        object = $this.F$1.raiseError((Object)new Throwable(msg));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return object;
                });
            }

            public GenTemporal<F, Throwable> temporal() {
                return this.F$1;
            }

            private F now() {
                if (!this.bitmap$init$0) {
                    throw new UninitializedFieldError("Uninitialized field: /home/runner/work/fs2-cron/fs2-cron/modules/calev/src/main/scala/eu/timepit/fs2cron/calev/CalevScheduler.scala: 53");
                }
                return this.now;
            }
            {
                this.F$1 = F$1;
                Scheduler.$init$((Scheduler)this);
                this.now = package.all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(F$1.realTimeInstant(), zoneId$1)).mapN((Function2 & Serializable)(x$1, x$2) -> x$1.atZone((ZoneId)x$2), (Functor)F$1, (Semigroupal)F$1);
                this.bitmap$init$0 = true;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fromNowUntilNext$1(eu.timepit.fs2cron.calev.CalevScheduler$$anon$1 com.github.eikek.calev.CalEvent java.time.ZonedDateTime ), $anonfun$now$1(java.time.Instant java.time.ZoneId )}, serializedLambda);
            }
        };
    }

    private CalevScheduler$() {
    }
}

