package eu.tarienna.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;

/**
 * A wrapper class for {@link Properties} to read and write UTF-8 encoded
 * property files.
 * 
 * @author Marcel Härle
 *
 */
public class UTF8Properties extends Properties {

	private static final long serialVersionUID = -216843275466194381L;

	/**
	 * Reads a property list (key and element pairs) from the input byte stream.
	 * The input stream is in a simple line-oriented format as specified in
	 * {@link #load(java.io.Reader) load(Reader)} and is assumed to use the ISO
	 * UTF-8 character encoding.
	 * <p>
	 * The specified stream remains open after this method returns.
	 *
	 * @param is
	 *            the input stream.
	 * @exception IOException
	 *                if an error occurred when reading from the input stream.
	 */
	@Override
	public void load(final InputStream is) throws IOException {
		readFromBufferedReader(new BufferedReader(new InputStreamReader(is)));
	}

	@Override
	public void load(final Reader reader) throws IOException {
		readFromBufferedReader(new BufferedReader(reader));
	}

	private void readFromBufferedReader(final BufferedReader reader)
			throws IOException {
		String line = reader.readLine();
		while (line != null) {
			if (!line.startsWith("#")) {
				final String[] keyValuePair = line.split("=");
				if (keyValuePair.length == 2) {
					put(keyValuePair[0], keyValuePair[1]);
				}
			}
			line = reader.readLine();
		}
	}

}
