/*
 * Decompiled with CFR 0.152.
 */
package eu.tarienna.jmshelper;

import eu.tarienna.jmshelper.AsyncReceiver;
import eu.tarienna.jmshelper.JmsMessageSender;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.util.Assert;

public class JmsMessageSenderImpl
implements JmsMessageSender {
    private final JmsTemplate jmsTemplate;

    public JmsMessageSenderImpl(JmsTemplate jmsTemplate) {
        Assert.notNull((Object)jmsTemplate);
        this.jmsTemplate = jmsTemplate;
    }

    @Override
    public String sendMessageAndReceiveReply(String text, String requestQueue, String responseQueue) throws JMSException {
        Assert.notNull((Object)text);
        Assert.notNull((Object)requestQueue);
        Assert.notNull((Object)responseQueue);
        String correlationId = this.createCorrelationId();
        MessageCreator messageCreator = session -> this.createMessage(session, text, responseQueue, correlationId);
        this.jmsTemplate.send(requestQueue, messageCreator);
        return this.receiveResponse(responseQueue, correlationId);
    }

    @Override
    public void sendMessageAndReceiveReply(String text, String requestQueue, String responseQueue, AsyncReceiver asyncReceiver) {
        Assert.notNull((Object)text);
        Assert.notNull((Object)requestQueue);
        Assert.notNull((Object)responseQueue);
        Assert.notNull((Object)asyncReceiver);
        String correlationId = this.createCorrelationId();
        MessageCreator messageCreator = session -> this.createMessage(session, text, responseQueue, correlationId);
        this.jmsTemplate.send(requestQueue, messageCreator);
        new Thread(() -> {
            try {
                asyncReceiver.receiveReply(this.receiveResponse(responseQueue, correlationId));
            }
            catch (JMSException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }).start();
    }

    @Override
    public void sendMessage(String text, String requestQueue) {
        Assert.notNull((Object)text);
        Assert.notNull((Object)requestQueue);
        MessageCreator messageCreator = session -> this.createMessage(session, text);
        this.jmsTemplate.send(requestQueue, messageCreator);
    }

    private String createCorrelationId() {
        return UUID.randomUUID().toString();
    }

    private Message createMessage(Session session, String text, String responseQueue, String correlationId) throws JMSException {
        TextMessage message = session.createTextMessage(text);
        message.setJMSCorrelationID(correlationId);
        message.setJMSReplyTo((Destination)session.createQueue(responseQueue));
        return message;
    }

    private Message createMessage(Session session, String text) throws JMSException {
        return session.createTextMessage(text);
    }

    private String createSelectorFrom(String correlationId) {
        return "JMSCorrelationID='" + correlationId + "'";
    }

    private String receiveResponse(String responseQueue, String correlationId) throws JMSException {
        String selector = this.createSelectorFrom(correlationId);
        Message message = this.jmsTemplate.receiveSelected(responseQueue, selector);
        if (message != null && message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            return textMessage.getText();
        }
        return null;
    }
}

