package eu.tarienna.jmshelper;

import javax.jms.JMSException;

/**
 * Helper to send message and receive replies.
 */
public interface JmsMessageSender {

    /**
     * Send the given text to the request queue and wait for the response from the given response queue.
     *
     * @param text          the text to be sent - must not be null
     * @param requestQueue  the request queue - must not be null
     * @param responseQueue the response queue - must not be null
     * @return returns the response text message, <code>null</code> if no text response
     * @throws JMSException when an JMS error occurs
     */
    String sendMessageAndReceiveReply(final String text, final String requestQueue,
                                      final String responseQueue) throws JMSException;

    /**
     * Send the given text to the request queue and receive async the response from the given response queue.
     *
     * @param text          the text to be sent - must not be null
     * @param requestQueue  the request queue - must not be null
     * @param responseQueue the response queue - must not be null
     * @param asyncReceiver the async receiver - must not be null
     */
    void sendMessageAndReceiveReply(final String text, final String requestQueue,
                                    final String responseQueue, final AsyncReceiver asyncReceiver);

    /**
     * Send the given text to the request queue.
     *
     * @param text         the text to be sent - must not null
     * @param requestQueue the request queue - must not be null
     */
    void sendMessage(final String text, final String requestQueue);

}
