/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.yarn;

import eu.stratosphere.nephele.taskmanager.TaskManager;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationConstants;

public class YarnTaskManagerRunner {
    private static final Log LOG = LogFactory.getLog(YarnTaskManagerRunner.class);

    public static void main(String[] args) throws IOException {
        Map<String, String> envs = System.getenv();
        String yarnClientUsername = envs.get("_CLIENT_USERNAME");
        String localDirs = envs.get(ApplicationConstants.Environment.LOCAL_DIRS.key());
        final String[] newArgs = Arrays.copyOf(args, args.length + 2);
        newArgs[newArgs.length - 2] = "-tempDir";
        newArgs[newArgs.length - 1] = localDirs;
        LOG.info((Object)("Setting log path " + localDirs));
        LOG.info((Object)("YARN daemon runs as '" + UserGroupInformation.getCurrentUser().getShortUserName() + "' setting" + " user to execute Stratosphere TaskManager to '" + yarnClientUsername + "'"));
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)yarnClientUsername);
        for (Token toks : UserGroupInformation.getCurrentUser().getTokens()) {
            ugi.addToken(toks);
        }
        ugi.doAs((PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    TaskManager.main((String[])newArgs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }
}

