/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.nephele.profiling.types.ProfilingEvent;
import eu.stratosphere.nephele.profiling.types.ThreadProfilingEvent;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYSeries;

public class VertexVisualizationData {
    private static final double ALPHA = 0.25;
    private final DefaultTableXYDataset threadDataSet;
    private final boolean isProfilingAvailable;
    private final XYSeries blockSeries;
    private final XYSeries waitSeries;
    private final XYSeries sysSeries;
    private final XYSeries usrSeries;
    private double averageUserRate = 0.0;
    private double averageWaitRate = 0.0;

    public VertexVisualizationData(boolean isProfilingAvailable) {
        this.isProfilingAvailable = isProfilingAvailable;
        if (this.isProfilingAvailable) {
            this.threadDataSet = new DefaultTableXYDataset();
            this.blockSeries = new XYSeries((Comparable)((Object)"BLK"), false, false);
            this.blockSeries.setNotify(false);
            this.waitSeries = new XYSeries((Comparable)((Object)"WAIT"), false, false);
            this.waitSeries.setNotify(false);
            this.sysSeries = new XYSeries((Comparable)((Object)"SYS"), false, false);
            this.sysSeries.setNotify(false);
            this.usrSeries = new XYSeries((Comparable)((Object)"USR"), false, false);
            this.usrSeries.setNotify(false);
            this.threadDataSet.addSeries(this.waitSeries);
            this.threadDataSet.addSeries(this.sysSeries);
            this.threadDataSet.addSeries(this.usrSeries);
            this.threadDataSet.addSeries(this.blockSeries);
        } else {
            this.threadDataSet = null;
            this.blockSeries = null;
            this.waitSeries = null;
            this.sysSeries = null;
            this.usrSeries = null;
        }
    }

    public TableXYDataset getThreadDataSet() {
        return this.threadDataSet;
    }

    public boolean isProfilingEnabledForJob() {
        return this.isProfilingAvailable;
    }

    public void processThreadProfilingEvent(ThreadProfilingEvent threadProfilingEvent) {
        double timestamp = VertexVisualizationData.getTimestamp((ProfilingEvent)threadProfilingEvent);
        this.averageUserRate = this.averageUserRate * 0.75 + (double)threadProfilingEvent.getUserTime() * 0.25;
        this.usrSeries.addOrUpdate((Number)timestamp, (Number)threadProfilingEvent.getUserTime());
        this.sysSeries.addOrUpdate((Number)timestamp, (Number)threadProfilingEvent.getSystemTime());
        this.averageWaitRate = this.averageWaitRate * 0.75 + (double)threadProfilingEvent.getWaitedTime() * 0.25;
        this.waitSeries.addOrUpdate((Number)timestamp, (Number)threadProfilingEvent.getWaitedTime());
        this.blockSeries.addOrUpdate((Number)timestamp, (Number)threadProfilingEvent.getBlockedTime());
    }

    public double getAverageWaitTime() {
        return this.averageWaitRate;
    }

    public double getAverageUserTime() {
        return this.averageUserRate;
    }

    public static final double getTimestamp(ProfilingEvent profilingEvent) {
        return Math.rint(profilingEvent.getProfilingTimestamp() / 1000L);
    }
}

