/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.GateVisualizationData;
import eu.stratosphere.addons.visualization.swt.GraphVisualizationData;
import eu.stratosphere.addons.visualization.swt.GroupEdgeVisualizationData;
import eu.stratosphere.addons.visualization.swt.GroupVertexVisualizationData;
import eu.stratosphere.addons.visualization.swt.InstanceVisualizationData;
import eu.stratosphere.addons.visualization.swt.LogoCanvas;
import eu.stratosphere.addons.visualization.swt.SWTAboutDialog;
import eu.stratosphere.addons.visualization.swt.SWTFailurePatternsManager;
import eu.stratosphere.addons.visualization.swt.SWTJobTabItem;
import eu.stratosphere.addons.visualization.swt.SWTJobToolTip;
import eu.stratosphere.addons.visualization.swt.VertexVisualizationData;
import eu.stratosphere.configuration.GlobalConfiguration;
import eu.stratosphere.core.io.StringRecord;
import eu.stratosphere.nephele.client.AbstractJobResult;
import eu.stratosphere.nephele.client.JobCancelResult;
import eu.stratosphere.nephele.event.job.AbstractEvent;
import eu.stratosphere.nephele.event.job.ExecutionStateChangeEvent;
import eu.stratosphere.nephele.event.job.JobEvent;
import eu.stratosphere.nephele.event.job.RecentJobEvent;
import eu.stratosphere.nephele.event.job.VertexAssignmentEvent;
import eu.stratosphere.nephele.event.job.VertexEvent;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.managementgraph.ManagementGate;
import eu.stratosphere.nephele.managementgraph.ManagementGraph;
import eu.stratosphere.nephele.managementgraph.ManagementGraphIterator;
import eu.stratosphere.nephele.managementgraph.ManagementGroupEdge;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertex;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertexIterator;
import eu.stratosphere.nephele.managementgraph.ManagementVertex;
import eu.stratosphere.nephele.managementgraph.ManagementVertexID;
import eu.stratosphere.nephele.profiling.types.InputGateProfilingEvent;
import eu.stratosphere.nephele.profiling.types.InstanceProfilingEvent;
import eu.stratosphere.nephele.profiling.types.InstanceSummaryProfilingEvent;
import eu.stratosphere.nephele.profiling.types.OutputGateProfilingEvent;
import eu.stratosphere.nephele.profiling.types.SingleInstanceProfilingEvent;
import eu.stratosphere.nephele.profiling.types.ThreadProfilingEvent;
import eu.stratosphere.nephele.profiling.types.VertexProfilingEvent;
import eu.stratosphere.nephele.protocols.ExtendedManagementProtocol;
import eu.stratosphere.nephele.topology.NetworkNode;
import eu.stratosphere.nephele.topology.NetworkTopology;
import eu.stratosphere.util.StringUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SWTVisualizationGUI
implements SelectionListener,
Runnable {
    private static final Log LOG = LogFactory.getLog(SWTVisualizationGUI.class);
    private static final String JAVA_DOC_URL = "http://www.stratosphere.eu/";
    private final int QUERYINTERVAL;
    private final Display display;
    private final Menu menuBar;
    private final Shell shell;
    private final Tree jobTree;
    private final boolean detectBottlenecks;
    private volatile boolean applyFailurePatterns = true;
    private final ExtendedManagementProtocol jobManager;
    private final CTabFolder jobTabFolder;
    private Map<JobID, GraphVisualizationData> recentJobs = new HashMap<JobID, GraphVisualizationData>();
    private final SWTFailurePatternsManager failurePatternsManager;
    private long lastProcessedEventSequenceNumber = -1L;

    public SWTVisualizationGUI(ExtendedManagementProtocol jobManager, int queryInterval) {
        this.jobManager = jobManager;
        this.QUERYINTERVAL = queryInterval;
        this.display = new Display();
        this.shell = new Shell(this.display);
        this.detectBottlenecks = GlobalConfiguration.getBoolean((String)"visualization.bottleneckDetection.enable", (boolean)false);
        this.shell.setText("Nephele Job Visualization");
        this.shell.setSize(1280, 1024);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.shell.setLayout((Layout)gridLayout);
        new LogoCanvas((Composite)this.shell, 0).setLayoutData(new GridData(768));
        SashForm horizontalSash = new SashForm((Composite)this.shell, 256);
        horizontalSash.setLayoutData((Object)new GridData(1808));
        Group jobGroup = new Group((Composite)horizontalSash, 0);
        jobGroup.setText("Recent Jobs");
        jobGroup.setLayout((Layout)new FillLayout());
        this.jobTree = new Tree((Composite)jobGroup, 2052);
        this.jobTree.addSelectionListener((SelectionListener)this);
        this.jobTree.setToolTipText("");
        Listener toolTipListener = new Listener(){
            private SWTJobToolTip jobToolTip = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.jobToolTip == null) break;
                        this.jobToolTip.dispose();
                        this.jobToolTip = null;
                        break;
                    }
                    case 32: {
                        TreeItem ti = SWTVisualizationGUI.this.jobTree.getItem(new Point(event.x, event.y));
                        if (ti == null) break;
                        if (this.jobToolTip != null && !this.jobToolTip.isDisposed()) {
                            this.jobToolTip.dispose();
                        }
                        Point pt = SWTVisualizationGUI.this.jobTree.toDisplay(event.x, event.y);
                        GraphVisualizationData gvi = (GraphVisualizationData)ti.getData();
                        if (gvi == null) break;
                        String jobName = gvi.getJobName();
                        JobID jobID = gvi.getJobID();
                        long submissionTimestamp = gvi.getSubmissionTimestamp();
                        this.jobToolTip = new SWTJobToolTip(SWTVisualizationGUI.this.shell, jobName, jobID, submissionTimestamp, pt.x, pt.y);
                    }
                }
            }
        };
        this.jobTree.addListener(12, toolTipListener);
        this.jobTree.addListener(1, toolTipListener);
        this.jobTree.addListener(5, toolTipListener);
        this.jobTree.addListener(32, toolTipListener);
        this.jobTabFolder = new CTabFolder((Composite)horizontalSash, 128);
        this.jobTabFolder.addSelectionListener((SelectionListener)this);
        horizontalSash.setWeights(new int[]{2, 8});
        this.menuBar = new Menu((Decorations)this.shell, 2);
        MenuItem fileMenuItem = new MenuItem(this.menuBar, 64);
        fileMenuItem.setText("&File");
        Menu fileMenu = new Menu((Decorations)this.shell, 4);
        fileMenuItem.setMenu(fileMenu);
        MenuItem fileExitItem = new MenuItem(fileMenu, 8);
        fileExitItem.setText("E&xit");
        fileExitItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SWTVisualizationGUI.this.shell.close();
                SWTVisualizationGUI.this.display.dispose();
            }
        });
        MenuItem jobMenuItem = new MenuItem(this.menuBar, 64);
        jobMenuItem.setText("&Job");
        Menu jobMenu = new Menu((Decorations)this.shell, 4);
        jobMenuItem.setMenu(jobMenu);
        MenuItem cancelJobItem = new MenuItem(jobMenu, 8);
        cancelJobItem.setText("&Cancel job");
        cancelJobItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SWTVisualizationGUI.this.cancelJob();
                SWTVisualizationGUI.this.shell.setMenuBar(null);
            }
        });
        MenuItem debuggingMenuItem = new MenuItem(this.menuBar, 64);
        debuggingMenuItem.setText("&Debugging");
        Menu debuggingMenu = new Menu((Decorations)this.shell, 4);
        debuggingMenuItem.setMenu(debuggingMenu);
        MenuItem debuggingLBUItem = new MenuItem(debuggingMenu, 8);
        debuggingLBUItem.setText("&Log buffer utilization");
        debuggingLBUItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SWTVisualizationGUI.this.logBufferUtilization();
                SWTVisualizationGUI.this.shell.setMenuBar(null);
            }
        });
        new MenuItem(debuggingMenu, 2);
        final MenuItem debuggingAFPItem = new MenuItem(debuggingMenu, 32);
        debuggingAFPItem.setText("&Apply failure patterns");
        debuggingAFPItem.setSelection(this.applyFailurePatterns);
        debuggingAFPItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SWTVisualizationGUI.this.applyFailurePatterns = debuggingAFPItem.getSelection();
                SWTVisualizationGUI.this.shell.setMenuBar(null);
            }
        });
        MenuItem debuggingMFPItem = new MenuItem(debuggingMenu, 8);
        debuggingMFPItem.setText("&Manage failure patterns...");
        debuggingMFPItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SWTVisualizationGUI.this.manageFailurePatterns();
                SWTVisualizationGUI.this.shell.setMenuBar(null);
            }
        });
        MenuItem helpMenuItem = new MenuItem(this.menuBar, 64);
        helpMenuItem.setText("&Help");
        Menu helpMenu = new Menu((Decorations)this.shell, 4);
        helpMenuItem.setMenu(helpMenu);
        MenuItem helpJavaDocItem = new MenuItem(helpMenu, 8);
        helpJavaDocItem.setText("&View JavaDoc...");
        helpJavaDocItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SWTVisualizationGUI.this.viewJavaDoc();
                SWTVisualizationGUI.this.shell.setMenuBar(null);
            }
        });
        new MenuItem(helpMenu, 2);
        MenuItem helpAboutItem = new MenuItem(helpMenu, 8);
        helpAboutItem.setText("&About...");
        helpAboutItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SWTVisualizationGUI.this.showAboutDialog();
                SWTVisualizationGUI.this.shell.setMenuBar(null);
            }
        });
        this.display.addFilter(1, new Listener(){

            public void handleEvent(Event arg0) {
                if (arg0.keyCode == 65536) {
                    if (SWTVisualizationGUI.this.shell.getMenuBar() == null) {
                        SWTVisualizationGUI.this.shell.setMenuBar(SWTVisualizationGUI.this.menuBar);
                    } else {
                        SWTVisualizationGUI.this.shell.setMenuBar(null);
                    }
                }
            }
        });
        this.display.addFilter(3, new Listener(){

            public void handleEvent(Event arg0) {
                if (SWTVisualizationGUI.this.shell.getMenuBar() != null) {
                    SWTVisualizationGUI.this.shell.setMenuBar(null);
                }
            }
        });
        this.failurePatternsManager = new SWTFailurePatternsManager(this.shell.getDisplay(), jobManager);
        this.display.timerExec(this.QUERYINTERVAL * 1000, (Runnable)this);
    }

    public Shell getShell() {
        return this.shell;
    }

    public Display getDisplay() {
        return this.display;
    }

    private void createJobTab(GraphVisualizationData visualizationData) {
        JobID jobID = visualizationData.getManagementGraph().getJobID();
        CTabItem jobTabItem = new CTabItem(this.jobTabFolder, 64);
        jobTabItem.setText(visualizationData.getJobName());
        jobTabItem.setData((Object)jobID);
        SWTJobTabItem swtTabItem = new SWTJobTabItem(this, visualizationData, (Composite)this.jobTabFolder, 0, this.detectBottlenecks);
        jobTabItem.setControl((Control)swtTabItem);
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent arg0) {
        if (arg0.widget == this.jobTree) {
            Widget selectedWidget = arg0.widget;
            if (!(selectedWidget instanceof Tree)) {
                return;
            }
            Tree tree = (Tree)selectedWidget;
            TreeItem[] selectedItems = tree.getSelection();
            if (selectedItems.length != 1) {
                return;
            }
            TreeItem selectedItem = selectedItems[0];
            GraphVisualizationData visualizationData = (GraphVisualizationData)selectedItem.getData();
            if (visualizationData == null) {
                return;
            }
            int index = this.getJobTabIndex(visualizationData.getManagementGraph().getJobID());
            if (index >= 0) {
                this.jobTabFolder.setSelection(index);
                return;
            }
            this.createJobTab(visualizationData);
            this.jobTabFolder.setSelection(this.jobTabFolder.getItemCount() - 1);
        }
    }

    private int getJobTabIndex(JobID jobID) {
        for (int i = 0; i < this.jobTabFolder.getItemCount(); ++i) {
            JobID candidateID;
            CTabItem item = this.jobTabFolder.getItem(i);
            if (item.getData() == null || !(item.getData() instanceof JobID) || !(candidateID = (JobID)item.getData()).equals((Object)jobID)) continue;
            return i;
        }
        return -1;
    }

    public void killTask(JobID jobId, ManagementVertexID id, String vertexName) {
        MessageBox messageBox = new MessageBox(this.getShell(), 196);
        messageBox.setText("Confirmation");
        messageBox.setMessage("Do you really want to cancel the task " + vertexName + "(" + id.toString() + ")?");
        if (messageBox.open() != 64) {
            return;
        }
        try {
            this.jobManager.killTask(jobId, id);
        }
        catch (IOException ioe) {
            MessageBox errorBox = new MessageBox(this.getShell(), 1);
            errorBox.setText("Error");
            errorBox.setMessage(StringUtils.stringifyException((Throwable)ioe));
            errorBox.open();
        }
    }

    public void killInstance(String instanceName) {
        MessageBox messageBox = new MessageBox(this.getShell(), 196);
        messageBox.setText("Confirmation");
        messageBox.setMessage("Do you really want to kill the instance " + instanceName + "?");
        if (messageBox.open() != 64) {
            return;
        }
        try {
            this.jobManager.killInstance(new StringRecord(instanceName));
        }
        catch (IOException ioe) {
            MessageBox errorBox = new MessageBox(this.getShell(), 1);
            errorBox.setText("Error");
            errorBox.setMessage(StringUtils.stringifyException((Throwable)ioe));
            errorBox.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean viewUpdateRequired = false;
        try {
            List newJobs = this.jobManager.getRecentJobs();
            Collections.sort(newJobs, new Comparator<RecentJobEvent>(){

                @Override
                public int compare(RecentJobEvent o1, RecentJobEvent o2) {
                    return (int)(o1.getSubmissionTimestamp() - o2.getSubmissionTimestamp());
                }
            });
            if (!newJobs.isEmpty()) {
                for (RecentJobEvent newJobEvent : newJobs) {
                    this.addJob(newJobEvent.getJobID(), newJobEvent.getJobName(), newJobEvent.isProfilingAvailable(), newJobEvent.getSubmissionTimestamp(), newJobEvent.getTimestamp());
                }
            }
            Map<JobID, GraphVisualizationData> map = this.recentJobs;
            synchronized (map) {
                for (JobID jobID : this.recentJobs.keySet()) {
                    JobID jobIDOfSelectedTab;
                    List events = this.jobManager.getEvents(jobID);
                    if (events.isEmpty()) continue;
                    CTabItem selectedTab = this.jobTabFolder.getSelection();
                    if (selectedTab != null && jobID.equals((Object)(jobIDOfSelectedTab = (JobID)selectedTab.getData()))) {
                        viewUpdateRequired = true;
                    }
                    GraphVisualizationData graphVisualizationData = this.recentJobs.get(jobID);
                    for (AbstractEvent event : events) {
                        if (this.lastProcessedEventSequenceNumber >= event.getSequenceNumber()) continue;
                        this.dispatchEvent(event, graphVisualizationData);
                        this.lastProcessedEventSequenceNumber = event.getSequenceNumber();
                    }
                }
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)ioe));
        }
        if (viewUpdateRequired) {
            this.updateView();
        }
        this.display.timerExec(this.QUERYINTERVAL * 1000, (Runnable)this);
    }

    private void updateView() {
        CTabItem selectedTabItem = this.jobTabFolder.getSelection();
        if (selectedTabItem == null) {
            return;
        }
        Control control = selectedTabItem.getControl();
        if (control == null) {
            return;
        }
        if (!(control instanceof SWTJobTabItem)) {
            return;
        }
        ((SWTJobTabItem)control).updateView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJob(JobID jobID, String jobName, boolean isProfilingAvailable, long submissionTimestamp, long referenceTime) throws IOException {
        Map<JobID, GraphVisualizationData> map = this.recentJobs;
        synchronized (map) {
            if (this.recentJobs.containsKey(jobID)) {
                return;
            }
            ManagementGraph managementGraph = this.jobManager.getManagementGraph(jobID);
            NetworkTopology networkTopology = this.jobManager.getNetworkTopology(jobID);
            GraphVisualizationData graphVisualizationData = new GraphVisualizationData(jobID, jobName, isProfilingAvailable, submissionTimestamp, managementGraph, networkTopology);
            managementGraph.setAttachment((Object)graphVisualizationData);
            ManagementGraphIterator it = new ManagementGraphIterator(managementGraph, true);
            while (it.hasNext()) {
                int i;
                ManagementVertex vertex = (ManagementVertex)it.next();
                vertex.setAttachment((Object)new VertexVisualizationData(isProfilingAvailable));
                for (i = 0; i < vertex.getNumberOfOutputGates(); ++i) {
                    vertex.getOutputGate(i).setAttachment((Object)new GateVisualizationData(isProfilingAvailable));
                }
                for (i = 0; i < vertex.getNumberOfInputGates(); ++i) {
                    vertex.getInputGate(i).setAttachment((Object)new GateVisualizationData(isProfilingAvailable));
                }
            }
            ManagementGroupVertexIterator it2 = new ManagementGroupVertexIterator(managementGraph, true, -1);
            while (it2.hasNext()) {
                ManagementGroupVertex groupVertex = (ManagementGroupVertex)it2.next();
                groupVertex.setAttachment((Object)new GroupVertexVisualizationData(groupVertex));
                for (int i = 0; i < groupVertex.getNumberOfForwardEdges(); ++i) {
                    ManagementGroupEdge groupEdge = groupVertex.getForwardEdge(i);
                    groupEdge.setAttachment((Object)new GroupEdgeVisualizationData(groupEdge));
                }
            }
            for (NetworkNode networkNode : networkTopology) {
                if (!networkNode.isLeafNode()) continue;
                networkNode.setAttachment((Object)new InstanceVisualizationData(isProfilingAvailable));
            }
            networkTopology.setAttachment((Object)new InstanceVisualizationData(isProfilingAvailable));
            TreeItem jobItem = new TreeItem(this.jobTree, 0);
            jobItem.setText(jobName + " (" + jobID.toString() + ")");
            jobItem.setData((Object)graphVisualizationData);
            this.failurePatternsManager.startFailurePattern(jobName, managementGraph, referenceTime);
            this.recentJobs.put(jobID, graphVisualizationData);
        }
    }

    private void dispatchEvent(AbstractEvent event, GraphVisualizationData graphVisualizationData) {
        if (event instanceof VertexProfilingEvent) {
            VertexProfilingEvent vertexProfilingEvent = (VertexProfilingEvent)event;
            ManagementGraph graph = graphVisualizationData.getManagementGraph();
            ManagementVertex vertex = graph.getVertexByID(vertexProfilingEvent.getVertexID());
            if (vertexProfilingEvent instanceof ThreadProfilingEvent) {
                VertexVisualizationData vertexVisualizationData = (VertexVisualizationData)vertex.getAttachment();
                vertexVisualizationData.processThreadProfilingEvent((ThreadProfilingEvent)vertexProfilingEvent);
            } else if (vertexProfilingEvent instanceof OutputGateProfilingEvent) {
                OutputGateProfilingEvent outputGateProfilingEvent = (OutputGateProfilingEvent)vertexProfilingEvent;
                ManagementGate managementGate = vertex.getOutputGate(outputGateProfilingEvent.getGateIndex());
                GateVisualizationData gateVisualizationData = (GateVisualizationData)managementGate.getAttachment();
                gateVisualizationData.processOutputGateProfilingEvent(outputGateProfilingEvent);
            } else if (vertexProfilingEvent instanceof InputGateProfilingEvent) {
                InputGateProfilingEvent inputGateProfilingEvent = (InputGateProfilingEvent)vertexProfilingEvent;
                ManagementGate managementGate = vertex.getInputGate(inputGateProfilingEvent.getGateIndex());
                GateVisualizationData gateVisualizationData = (GateVisualizationData)managementGate.getAttachment();
                gateVisualizationData.processInputGateProfilingEvent(inputGateProfilingEvent);
            }
        } else if (event instanceof InstanceProfilingEvent) {
            NetworkTopology networkTopology = graphVisualizationData.getNetworkTopology();
            if (event instanceof InstanceSummaryProfilingEvent) {
                InstanceVisualizationData instanceVisualizationData = (InstanceVisualizationData)networkTopology.getAttachment();
                instanceVisualizationData.processInstanceProfilingEvent((InstanceProfilingEvent)((InstanceSummaryProfilingEvent)event));
            } else {
                SingleInstanceProfilingEvent singleInstanceProfilingEvent = (SingleInstanceProfilingEvent)event;
                NetworkNode networkNode = networkTopology.getNodeByName(singleInstanceProfilingEvent.getInstanceName());
                InstanceVisualizationData instanceVisualizationData = (InstanceVisualizationData)networkNode.getAttachment();
                instanceVisualizationData.processInstanceProfilingEvent((InstanceProfilingEvent)singleInstanceProfilingEvent);
            }
        } else if (event instanceof ExecutionStateChangeEvent) {
            ExecutionStateChangeEvent executionStateChangeEvent = (ExecutionStateChangeEvent)event;
            ManagementGraph graph = graphVisualizationData.getManagementGraph();
            ManagementVertex vertex = graph.getVertexByID(executionStateChangeEvent.getVertexID());
            vertex.setExecutionState(executionStateChangeEvent.getNewExecutionState());
        } else if (event instanceof VertexAssignmentEvent) {
            VertexAssignmentEvent vertexAssignmentEvent = (VertexAssignmentEvent)event;
            ManagementGraph graph = graphVisualizationData.getManagementGraph();
            ManagementVertex vertex = graph.getVertexByID(vertexAssignmentEvent.getVertexID());
            vertex.setInstanceName(vertexAssignmentEvent.getInstanceName());
            vertex.setInstanceType(vertexAssignmentEvent.getInstanceType());
        } else if (!(event instanceof JobEvent) && !(event instanceof VertexEvent)) {
            System.out.println("Unknown event: " + event);
        }
    }

    private void manageFailurePatterns() {
        HashSet<String> jobSuggestions = new HashSet<String>();
        HashSet<String> nameSuggestions = new HashSet<String>();
        for (GraphVisualizationData gvd : this.recentJobs.values()) {
            jobSuggestions.add(gvd.getJobName());
            ManagementGraphIterator mgi = new ManagementGraphIterator(gvd.getManagementGraph(), true);
            while (mgi.hasNext()) {
                ManagementVertex vertex = mgi.next();
                String vertexName = SWTFailurePatternsManager.getSuggestedName(vertex);
                nameSuggestions.add(vertexName);
                if (vertex.getInstanceName() == null) continue;
                nameSuggestions.add(vertex.getInstanceName());
            }
        }
        this.failurePatternsManager.openEditor(this.shell, jobSuggestions, nameSuggestions);
    }

    private void logBufferUtilization() {
        if (this.jobTree.getItemCount() == 0) {
            MessageBox msgBox = new MessageBox(this.shell, 33);
            msgBox.setText("No job available");
            msgBox.setMessage("Unable to log buffer utilization because no job is available.");
            msgBox.open();
            return;
        }
        TreeItem[] selectedItems = this.jobTree.getSelection();
        if (selectedItems.length == 0) {
            MessageBox msgBox = new MessageBox(this.shell, 34);
            msgBox.setText("No job selected");
            msgBox.setMessage("Please select at least one job for which the current buffer utilization shall be logged.");
            msgBox.open();
            return;
        }
        for (int i = 0; i < selectedItems.length; ++i) {
            TreeItem selectedItem = selectedItems[i];
            GraphVisualizationData visualizationData = (GraphVisualizationData)selectedItem.getData();
            if (visualizationData == null) continue;
            try {
                this.jobManager.logBufferUtilization(visualizationData.getJobID());
                continue;
            }
            catch (IOException ioe) {
                MessageBox msgBox = new MessageBox(this.shell, 33);
                msgBox.setText("Logging failed for job " + visualizationData.getJobID());
                msgBox.setMessage("Logging of buffer utilization failed for job " + visualizationData.getJobID() + ":\r\n\r\n" + ioe.getMessage());
            }
        }
        MessageBox msgBox = new MessageBox(this.shell, 34);
        msgBox.setText("Logging succesfull");
        msgBox.setMessage("The buffer utilization of the selected jobs have been successfully written to the instances' log files.");
        msgBox.open();
    }

    private void showAboutDialog() {
        SWTAboutDialog aboutDialog = new SWTAboutDialog(this.shell);
        aboutDialog.open();
    }

    private void viewJavaDoc() {
        Program.launch((String)JAVA_DOC_URL);
    }

    private void cancelJob() {
        if (this.jobTree.getItemCount() == 0) {
            MessageBox msgBox = new MessageBox(this.shell, 33);
            msgBox.setText("No job available");
            msgBox.setMessage("No job to cancel.");
            msgBox.open();
            return;
        }
        TreeItem[] selectedItems = this.jobTree.getSelection();
        if (selectedItems.length == 0) {
            MessageBox msgBox = new MessageBox(this.shell, 34);
            msgBox.setText("No job selected");
            msgBox.setMessage("Please select at least one job to cancel.");
            msgBox.open();
            return;
        }
        for (int i = 0; i < selectedItems.length; ++i) {
            MessageBox msgBox;
            TreeItem selectedItem = selectedItems[i];
            GraphVisualizationData visualizationData = (GraphVisualizationData)selectedItem.getData();
            if (visualizationData == null) continue;
            try {
                JobCancelResult cjr = this.jobManager.cancelJob(visualizationData.getJobID());
                if (cjr.getReturnCode() != AbstractJobResult.ReturnCode.ERROR) continue;
                msgBox = new MessageBox(this.shell, 33);
                msgBox.setText("Canceling job " + visualizationData.getJobID() + " failed");
                msgBox.setMessage("Canceling job " + visualizationData.getJobID() + " failed:\r\n\r\n" + cjr.getDescription());
                continue;
            }
            catch (IOException ioe) {
                msgBox = new MessageBox(this.shell, 33);
                msgBox.setText("Canceling job " + visualizationData.getJobID() + " failed");
                msgBox.setMessage("Canceling job " + visualizationData.getJobID() + " failed:\r\n\r\n" + ioe.getMessage());
            }
        }
        MessageBox msgBox = new MessageBox(this.shell, 34);
        msgBox.setText("Job(s) succesfully canceled");
        msgBox.setMessage("The selected jobs have been successfully canceled.");
        msgBox.open();
    }
}

