/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.SWTVisualizationGUI;
import eu.stratosphere.configuration.GlobalConfiguration;
import eu.stratosphere.nephele.ipc.RPC;
import eu.stratosphere.nephele.net.NetUtils;
import eu.stratosphere.nephele.protocols.ExtendedManagementProtocol;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SWTVisualization {
    private static final Log LOG = LogFactory.getLog(SWTVisualization.class);
    private static final String CONFIG_DIR_PARAMETER = "-configDir";

    public static void main(String[] args) {
        ExtendedManagementProtocol jobManager;
        String configDir = null;
        for (int i = 0; i < args.length - 1; ++i) {
            if (!CONFIG_DIR_PARAMETER.equals(args[i])) continue;
            configDir = args[i + 1];
            break;
        }
        if (configDir == null) {
            LOG.error((Object)"Please specify Nephele configuration directory with -configDir");
            System.exit(1);
            return;
        }
        GlobalConfiguration.loadConfiguration(configDir);
        String address = GlobalConfiguration.getString((String)"jobmanager.rpc.address", null);
        if (address == null) {
            LOG.error((Object)"Cannot find address to job manager's RPC service in configuration");
            System.exit(1);
            return;
        }
        int port = GlobalConfiguration.getInteger((String)"jobmanager.rpc.port", (int)-1);
        if (port < 0) {
            LOG.error((Object)"Cannot find port to job manager's RPC service in configuration");
            System.exit(1);
            return;
        }
        InetSocketAddress inetaddr = new InetSocketAddress(address, port);
        int queryInterval = -1;
        try {
            jobManager = (ExtendedManagementProtocol)RPC.getProxy(ExtendedManagementProtocol.class, (InetSocketAddress)inetaddr, (SocketFactory)NetUtils.getSocketFactory());
            queryInterval = jobManager.getRecommendedPollingInterval().getValue();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
        SWTVisualizationGUI swtVisualizationGUI = new SWTVisualizationGUI(jobManager, queryInterval);
        Shell shell = swtVisualizationGUI.getShell();
        Display display = swtVisualizationGUI.getDisplay();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

