/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.GroupVertexVisualizationData;
import eu.stratosphere.addons.visualization.swt.SWTToolTip;
import eu.stratosphere.addons.visualization.swt.SWTToolTipCommandReceiver;
import eu.stratosphere.addons.visualization.swt.VertexVisualizationData;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertex;
import eu.stratosphere.nephele.managementgraph.ManagementVertex;
import java.awt.Paint;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class SWTVertexToolTip
extends SWTToolTip {
    private static final String WARNINGTEXT = "Nephele has identified this task as a CPU bottleneck";
    private final Label instanceTypeLabel;
    private final Label instanceIDLabel;
    private final Label executionStateLabel;
    private Composite warningComposite;
    private final ManagementVertex managementVertex;
    private final ChartComposite threadChart;
    private static final int WIDTH = 400;

    public SWTVertexToolTip(Shell parent, SWTToolTipCommandReceiver commandReceiver, ManagementVertex managementVertex, int x, int y) {
        super(parent, x, y);
        int height;
        this.managementVertex = managementVertex;
        VertexVisualizationData vertexVisualizationData = (VertexVisualizationData)managementVertex.getAttachment();
        Color backgroundColor = this.getShell().getBackground();
        Color foregroundColor = this.getShell().getForeground();
        String taskName = managementVertex.getName() + " (" + (managementVertex.getIndexInGroup() + 1) + " of " + managementVertex.getNumberOfVerticesInGroup() + ")";
        this.setTitle(taskName);
        if (vertexVisualizationData.isProfilingEnabledForJob()) {
            this.threadChart = this.createThreadChart(vertexVisualizationData, backgroundColor);
            this.threadChart.setLayoutData((Object)new GridData(1808));
            height = 240;
        } else {
            this.threadChart = null;
            height = 125;
        }
        Composite tableComposite = new Composite((Composite)this.getShell(), 0);
        tableComposite.setLayoutData((Object)new GridData(768));
        tableComposite.setBackground(backgroundColor);
        tableComposite.setForeground(foregroundColor);
        GridLayout tableGridLayout = new GridLayout(3, false);
        tableGridLayout.marginHeight = 0;
        tableGridLayout.marginLeft = 0;
        tableComposite.setLayout((Layout)tableGridLayout);
        GridData gridData1 = new GridData();
        gridData1.horizontalSpan = 2;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.widthHint = 200;
        GridData gridData2 = new GridData();
        gridData2.grabExcessHorizontalSpace = true;
        Label instanceTypeTextLabel = new Label(tableComposite, 0);
        instanceTypeTextLabel.setBackground(backgroundColor);
        instanceTypeTextLabel.setForeground(foregroundColor);
        instanceTypeTextLabel.setText("Instance type:");
        this.instanceTypeLabel = new Label(tableComposite, 0);
        this.instanceTypeLabel.setBackground(backgroundColor);
        this.instanceTypeLabel.setForeground(foregroundColor);
        this.instanceTypeLabel.setText(this.managementVertex.getInstanceType());
        this.instanceTypeLabel.setLayoutData((Object)gridData1);
        Label instanceIDTextLabel = new Label(tableComposite, 0);
        instanceIDTextLabel.setBackground(backgroundColor);
        instanceIDTextLabel.setForeground(foregroundColor);
        instanceIDTextLabel.setText("Instance ID:");
        this.instanceIDLabel = new Label(tableComposite, 0);
        this.instanceIDLabel.setBackground(backgroundColor);
        this.instanceIDLabel.setForeground(foregroundColor);
        this.instanceIDLabel.setText(this.managementVertex.getInstanceName());
        this.instanceIDLabel.setLayoutData((Object)gridData2);
        Button switchToInstanceButton = new Button(tableComposite, 8);
        switchToInstanceButton.setText("Switch to instance...");
        switchToInstanceButton.setEnabled(vertexVisualizationData.isProfilingEnabledForJob());
        switchToInstanceButton.setVisible(false);
        Label executionStateTextLabel = new Label(tableComposite, 0);
        executionStateTextLabel.setBackground(backgroundColor);
        executionStateTextLabel.setForeground(foregroundColor);
        executionStateTextLabel.setText("Execution state:");
        this.executionStateLabel = new Label(tableComposite, 0);
        this.executionStateLabel.setBackground(backgroundColor);
        this.executionStateLabel.setForeground(foregroundColor);
        this.executionStateLabel.setText(this.managementVertex.getExecutionState().toString());
        this.executionStateLabel.setLayoutData((Object)gridData1);
        ManagementGroupVertex groupVertex = this.managementVertex.getGroupVertex();
        GroupVertexVisualizationData groupVertexVisualizationData = (GroupVertexVisualizationData)groupVertex.getAttachment();
        if (groupVertexVisualizationData.isCPUBottleneck()) {
            this.warningComposite = this.createWarningComposite(WARNINGTEXT, 8);
            height += 20;
        } else {
            this.warningComposite = null;
        }
        Composite taskActionComposite = new Composite((Composite)this.getShell(), 0);
        taskActionComposite.setLayout((Layout)new RowLayout(256));
        taskActionComposite.setBackground(backgroundColor);
        taskActionComposite.setForeground(foregroundColor);
        this.getShell().setSize(400, height);
        this.finishInstantiation(x, y, 400, false);
    }

    private ChartComposite createThreadChart(VertexVisualizationData visualizationData, Color backgroundColor) {
        JFreeChart chart = ChartFactory.createStackedXYAreaChart(null, (String)"Time [sec.]", (String)"Thread Utilization [%]", (TableXYDataset)visualizationData.getThreadDataSet(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)new java.awt.Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue()));
        XYPlot xyPlot = chart.getXYPlot();
        xyPlot.getDomainAxis().setAutoRange(true);
        xyPlot.getDomainAxis().setAutoRangeMinimumSize(60.0);
        xyPlot.getRangeAxis().setRange(0.0, 100.0);
        return new ChartComposite((Composite)this.getShell(), 0, chart, true);
    }

    @Override
    public void updateView() {
        if (this.threadChart != null) {
            this.threadChart.getChart().getXYPlot().configureDomainAxes();
            this.threadChart.getChart().fireChartChanged();
        }
        this.executionStateLabel.setText(this.managementVertex.getExecutionState().toString());
        this.instanceIDLabel.setText(this.managementVertex.getInstanceName());
        this.instanceTypeLabel.setText(this.managementVertex.getInstanceType());
        ManagementGroupVertex groupVertex = this.managementVertex.getGroupVertex();
        GroupVertexVisualizationData groupVertexVisualizationData = (GroupVertexVisualizationData)groupVertex.getAttachment();
        if (groupVertexVisualizationData.isCPUBottleneck()) {
            if (this.warningComposite == null) {
                this.warningComposite = this.createWarningComposite(WARNINGTEXT, 8);
                Rectangle clientRect = this.getShell().getClientArea();
                clientRect.height += 20;
                this.getShell().setSize(clientRect.width, clientRect.height);
            }
        } else if (this.warningComposite != null) {
            this.warningComposite.dispose();
            this.warningComposite = null;
            Rectangle clientRect = this.getShell().getClientArea();
            clientRect.height -= 20;
            this.getShell().setSize(clientRect.width, clientRect.height);
        }
    }
}

