/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.AbstractSWTComponent;
import eu.stratosphere.addons.visualization.swt.AbstractSWTVertex;
import eu.stratosphere.addons.visualization.swt.ColorScheme;
import eu.stratosphere.addons.visualization.swt.GroupVertexVisualizationData;
import eu.stratosphere.addons.visualization.swt.SWTGate;
import eu.stratosphere.addons.visualization.swt.SWTToolTip;
import eu.stratosphere.addons.visualization.swt.SWTToolTipCommandReceiver;
import eu.stratosphere.addons.visualization.swt.SWTVertexToolTip;
import eu.stratosphere.nephele.managementgraph.ManagementVertex;
import java.util.Iterator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Shell;

public class SWTVertex
extends AbstractSWTVertex {
    private static final int SPACEFORGATESINPERCENT = 20;
    private int gateHeight = 0;
    private final ManagementVertex managementVertex;

    public SWTVertex(AbstractSWTComponent parent, ManagementVertex managementVertex) {
        super(parent);
        this.managementVertex = managementVertex;
    }

    @Override
    public void layout() {
        int numberOfInputGates = 0;
        int numberOfOutputGates = 0;
        Iterator<AbstractSWTComponent> it = this.getChildren();
        while (it.hasNext()) {
            AbstractSWTComponent child = it.next();
            if (!(child instanceof SWTGate)) continue;
            SWTGate gate = (SWTGate)child;
            if (gate.isInputGate()) {
                ++numberOfInputGates;
                continue;
            }
            ++numberOfOutputGates;
        }
        int numberOfLayoutedInputGates = 0;
        int numberOfLayoutedOutputGates = 0;
        int inputGateWidth = 0;
        if (numberOfInputGates > 0) {
            inputGateWidth = this.getWidth() / numberOfInputGates;
        }
        int outputGateWidth = 0;
        if (numberOfOutputGates > 0) {
            outputGateWidth = this.getWidth() / numberOfOutputGates;
        }
        this.gateHeight = (int)((double)this.getHeight() * (double)0.2f);
        it = this.getChildren();
        while (it.hasNext()) {
            AbstractSWTComponent child = it.next();
            if (!(child instanceof SWTGate)) continue;
            SWTGate gate = (SWTGate)child;
            gate.setHeight(this.gateHeight);
            if (gate.isInputGate()) {
                gate.setX(this.getX() + numberOfLayoutedInputGates * inputGateWidth);
                gate.setY(this.getY() + this.getHeight() - this.gateHeight);
                gate.setWidth(inputGateWidth);
                ++numberOfLayoutedInputGates;
                continue;
            }
            gate.setX(this.getX() + numberOfLayoutedOutputGates * outputGateWidth);
            gate.setY(this.getY());
            gate.setWidth(outputGateWidth);
            ++numberOfLayoutedOutputGates;
        }
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    protected void paintInternal(GC gc, Device device) {
        GroupVertexVisualizationData groupVertexVisualizationData = (GroupVertexVisualizationData)this.managementVertex.getGroupVertex().getAttachment();
        if (groupVertexVisualizationData.isCPUBottleneck()) {
            gc.setBackground(this.getBackgroundColor(device));
        } else {
            gc.setBackground(this.getBackgroundColor(device));
        }
        gc.fillRectangle(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
    }

    private Color getBackgroundColor(Device device) {
        Color returnColor = null;
        switch (this.managementVertex.getExecutionState()) {
            case RUNNING: {
                returnColor = ColorScheme.getVertexRunningBackgroundColor(device);
                break;
            }
            case FINISHING: {
                returnColor = ColorScheme.getVertexFinishingBackgroundColor(device);
                break;
            }
            case FINISHED: {
                returnColor = ColorScheme.getVertexFinishedBackgroundColor(device);
                break;
            }
            case CANCELING: 
            case CANCELED: {
                returnColor = ColorScheme.getVertexCancelBackgroundColor(device);
                break;
            }
            case FAILED: {
                returnColor = ColorScheme.getVertexFailedBackgroundColor(device);
                break;
            }
            default: {
                returnColor = ColorScheme.getVertexDefaultBackgroundColor(device);
            }
        }
        return returnColor;
    }

    @Override
    public SWTToolTip constructToolTip(Shell parentShell, SWTToolTipCommandReceiver commandReceiver, int x, int y) {
        return new SWTVertexToolTip(parentShell, commandReceiver, this.managementVertex, x, y);
    }
}

