/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.AbstractSWTComponent;
import eu.stratosphere.addons.visualization.swt.GraphVisualizationData;
import eu.stratosphere.addons.visualization.swt.SWTJobTabItem;
import eu.stratosphere.addons.visualization.swt.SWTNetworkNode;
import eu.stratosphere.addons.visualization.swt.SWTNetworkTopology;
import eu.stratosphere.addons.visualization.swt.SWTToolTip;
import eu.stratosphere.addons.visualization.swt.SWTToolTipCommandReceiver;
import eu.stratosphere.nephele.managementgraph.ManagementVertexID;
import eu.stratosphere.nephele.topology.NetworkNode;
import eu.stratosphere.nephele.topology.NetworkTopology;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SWTTopologyCanvas
extends Canvas
implements PaintListener,
Listener,
MouseMoveListener,
SWTToolTipCommandReceiver {
    private final SWTNetworkTopology swtNetworkTopology;
    private AbstractSWTComponent toolTipComponent = null;
    private SWTToolTip displayedToolTip = null;
    private final SWTJobTabItem jobTabItem;

    public SWTTopologyCanvas(GraphVisualizationData visualizationData, SWTJobTabItem jobTabItem, Composite parent, int style) {
        super(parent, style);
        this.jobTabItem = jobTabItem;
        this.swtNetworkTopology = this.createSWTNetworkTopology(visualizationData.getNetworkTopology());
        this.addListener(11, this);
        this.addPaintListener(this);
        this.addMouseMoveListener(this);
    }

    private SWTNetworkTopology createSWTNetworkTopology(NetworkTopology networkTopology) {
        SWTNetworkTopology swtNetworkTopology = new SWTNetworkTopology(networkTopology);
        HashMap<NetworkNode, SWTNetworkNode> nodeMap = new HashMap<NetworkNode, SWTNetworkNode>();
        for (NetworkNode networkNode : networkTopology) {
            SWTNetworkNode swtNetworkNode = new SWTNetworkNode(this.getDisplay(), swtNetworkTopology, networkNode);
            swtNetworkTopology.addChild(swtNetworkNode);
            nodeMap.put(networkNode, swtNetworkNode);
            if (networkNode.getParentNode() != null) continue;
            swtNetworkTopology.setRootNode(swtNetworkNode);
        }
        for (Map.Entry entry : nodeMap.entrySet()) {
            NetworkNode childNode = (NetworkNode)entry.getKey();
            NetworkNode parentNode = childNode.getParentNode();
            if (parentNode == null) continue;
            SWTNetworkNode swtChildNode = (SWTNetworkNode)entry.getValue();
            SWTNetworkNode swtParentNode = (SWTNetworkNode)nodeMap.get(parentNode);
            swtChildNode.setParentNode(swtParentNode);
        }
        return swtNetworkTopology;
    }

    public void updateView() {
        this.redraw();
        if (this.displayedToolTip != null && !this.displayedToolTip.isDisposed()) {
            this.displayedToolTip.updateView();
        }
    }

    public void paintControl(PaintEvent arg0) {
        this.swtNetworkTopology.paint(arg0.gc, (Device)this.getDisplay());
    }

    public void handleEvent(Event arg0) {
        if (this.swtNetworkTopology != null) {
            Rectangle rect = this.getClientArea();
            this.swtNetworkTopology.setX(rect.x);
            this.swtNetworkTopology.setY(rect.y);
            this.swtNetworkTopology.setWidth(rect.width);
            this.swtNetworkTopology.setHeight(rect.height);
            this.swtNetworkTopology.layout();
        }
    }

    public void mouseMove(MouseEvent arg0) {
        AbstractSWTComponent selectedComponent = this.swtNetworkTopology.getSelectedComponent(arg0.x, arg0.y);
        if (selectedComponent == null) {
            if (this.toolTipComponent != null) {
                this.displayedToolTip.dispose();
                this.displayedToolTip = null;
                this.toolTipComponent = null;
            }
        } else {
            Point clientPoint = this.toDisplay(arg0.x, arg0.y);
            if (selectedComponent == this.toolTipComponent) {
                if (this.displayedToolTip != null) {
                    this.displayedToolTip.move(clientPoint.x, clientPoint.y);
                }
            } else {
                if (this.displayedToolTip != null && !this.displayedToolTip.isDisposed()) {
                    this.displayedToolTip.dispose();
                }
                this.displayedToolTip = selectedComponent.constructToolTip(this.getShell(), this, clientPoint.x, clientPoint.y);
                if (this.displayedToolTip != null) {
                    this.displayedToolTip.move(clientPoint.x, clientPoint.y);
                    this.toolTipComponent = selectedComponent;
                } else {
                    this.toolTipComponent = null;
                }
            }
        }
    }

    @Override
    public void killTask(ManagementVertexID id, String taskName) {
    }

    @Override
    public void killInstance(String instanceName) {
        this.jobTabItem.killInstance(instanceName);
    }

    @Override
    public void switchToInstance(String instanceName) {
    }
}

