/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.FontScheme;
import eu.stratosphere.addons.visualization.swt.SWTImageCanvas;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class SWTToolTip {
    protected static final int ICONSIZE = 20;
    private final Shell shell;
    private final Label titleLabel;
    private static final int OFFSET = 20;

    public SWTToolTip(Shell parent, int x, int y) {
        this.shell = new Shell(parent, 540676);
        GridLayout gridLayout = new GridLayout(1, false);
        this.shell.setLayout((Layout)gridLayout);
        Color backgroundColor = this.shell.getDisplay().getSystemColor(29);
        Color foregroundColor = this.shell.getDisplay().getSystemColor(28);
        this.shell.setBackground(backgroundColor);
        this.shell.setForeground(foregroundColor);
        this.titleLabel = new Label((Composite)this.shell, 0);
        this.titleLabel.setFont(FontScheme.getToolTipTitleFont((Device)parent.getDisplay()));
        this.titleLabel.setBackground(backgroundColor);
        this.titleLabel.setForeground(foregroundColor);
        this.titleLabel.setLayoutData((Object)new GridData(768));
    }

    protected void finishInstantiation(int x, int y, int width, boolean pack) {
        Rectangle displayBounds = this.shell.getDisplay().getPrimaryMonitor().getBounds();
        x = x + 20 + this.shell.getBounds().width > displayBounds.x + displayBounds.width ? (x -= this.shell.getBounds().width + 20) : (x += 20);
        this.shell.setLocation(x, y + 20);
        if (pack) {
            this.shell.pack();
        }
        this.shell.setVisible(true);
    }

    public void dispose() {
        this.shell.dispose();
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    public void move(int x, int y) {
        Rectangle displayBounds = this.shell.getDisplay().getPrimaryMonitor().getBounds();
        x = x + 20 + this.shell.getBounds().width > displayBounds.x + displayBounds.width ? (x -= this.shell.getBounds().width + 20) : (x += 20);
        this.shell.setLocation(x, y + 20);
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public abstract void updateView();

    protected Composite createWarningComposite(String text, int imageType) {
        Image image = this.getShell().getDisplay().getSystemImage(imageType);
        Color backgroundColor = this.getShell().getBackground();
        Color foregroundColor = this.getShell().getForeground();
        Composite composite = new Composite((Composite)this.getShell(), 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        composite.setBackground(backgroundColor);
        composite.setForeground(foregroundColor);
        SWTImageCanvas imageCanvas = new SWTImageCanvas(composite, 0, image);
        imageCanvas.setLayoutData(new GridData(20, 20));
        imageCanvas.setBackground(backgroundColor);
        imageCanvas.setForeground(foregroundColor);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(2, 2, true, true));
        label.setBackground(backgroundColor);
        label.setForeground(foregroundColor);
        label.setText(text);
        return composite;
    }
}

