/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.AbstractSWTComponent;
import eu.stratosphere.addons.visualization.swt.AbstractSWTVertex;
import eu.stratosphere.addons.visualization.swt.ColorScheme;
import java.util.Iterator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class SWTStage
extends AbstractSWTVertex {
    private static final int ARC_DIM = 10;
    private static final int SPACING = 20;
    private static final int NAMERECTWIDTH = 50;
    private AbstractSWTVertex[][] layoutMap = null;
    private int largestNumberOfParallelVertices = 1;
    private boolean uncluttered = false;

    public SWTStage(AbstractSWTComponent parent) {
        super(parent);
    }

    @Override
    public void layout() {
        if (this.layoutMap == null) {
            this.buildLayoutMap();
        }
        int height = this.getHeight() / this.layoutMap.length - 40;
        int width = (this.getWidth() - 50) / this.largestNumberOfParallelVertices - 40;
        for (int i = 0; i < this.layoutMap.length; ++i) {
            for (int j = 0; j < this.layoutMap[i].length; ++j) {
                AbstractSWTVertex child = this.layoutMap[i][j];
                int offset = (this.largestNumberOfParallelVertices - this.layoutMap[i].length) * (width + 40) / 2;
                int y = this.getY() + (this.layoutMap.length - i - 1) * (height + 40) + 20;
                int x = this.getX() + 50 + offset + (j + 1) * 20 + j * (width + 20);
                child.setHeight(height);
                child.setWidth(width);
                child.setX(x);
                child.setY(y);
            }
        }
        if (this.layoutMap != null && !this.uncluttered && this.getWidth() > 0) {
            this.unclutterLayoutMap();
            this.uncluttered = true;
        }
        this.layoutChildren();
    }

    private void unclutterLayoutMap() {
        for (int i = 0; i < this.layoutMap.length - 1; ++i) {
            int smallestLengthOfStage = this.getSumOfEdgeLengths(i);
            for (int j = 1; j < this.layoutMap[i].length; ++j) {
                this.swapRects(i, j, j - 1);
                int tmp = this.getSumOfEdgeLengths(i);
                if (tmp < smallestLengthOfStage) {
                    smallestLengthOfStage = tmp;
                    continue;
                }
                this.swapRects(i, j, j - 1);
            }
        }
    }

    private void swapRects(int stage, int i, int j) {
        int swap_x = this.layoutMap[stage][i].getX();
        int swap_y = this.layoutMap[stage][i].getY();
        int swap_width = this.layoutMap[stage][i].getWidth();
        int swap_height = this.layoutMap[stage][i].getHeight();
        this.layoutMap[stage][i].setX(this.layoutMap[stage][j].getX());
        this.layoutMap[stage][i].setY(this.layoutMap[stage][j].getY());
        this.layoutMap[stage][i].setWidth(this.layoutMap[stage][j].getWidth());
        this.layoutMap[stage][i].setHeight(this.layoutMap[stage][j].getHeight());
        this.layoutMap[stage][j].setX(swap_x);
        this.layoutMap[stage][j].setY(swap_y);
        this.layoutMap[stage][j].setWidth(swap_width);
        this.layoutMap[stage][j].setHeight(swap_height);
    }

    private int getSumOfEdgeLengths(int lowerStage) {
        int sumOfEdgeLengths = 0;
        for (int i = 0; i < this.layoutMap[lowerStage].length; ++i) {
            AbstractSWTVertex source = this.layoutMap[lowerStage][i];
            Iterator<AbstractSWTVertex> it = source.getEdges();
            while (it.hasNext()) {
                AbstractSWTVertex target = it.next();
                sumOfEdgeLengths += this.getLengthOfLine(source, target);
            }
        }
        return sumOfEdgeLengths;
    }

    private int getLengthOfLine(AbstractSWTVertex source, AbstractSWTVertex target) {
        int x = Math.abs(target.getEdgeTargetX() - source.getEdgeSourceX());
        int y = Math.abs(target.getEdgeTargetY() - source.getEdgeSourceY());
        return (int)Math.sqrt(x * x + y * y);
    }

    private void buildLayoutMap() {
        AbstractSWTVertex childVertex;
        AbstractSWTComponent child;
        int i;
        int longestPath = this.getLongestPathAmongChildren() + 1;
        int[] verticesPerSubStage = new int[longestPath];
        this.layoutMap = new AbstractSWTVertex[longestPath][];
        for (i = 0; i < this.getNumberOfChildren(); ++i) {
            child = this.getChildAt(i);
            if (!(child instanceof AbstractSWTVertex)) continue;
            childVertex = (AbstractSWTVertex)child;
            int n = longestPath - childVertex.getLongestPath(this) - 1;
            verticesPerSubStage[n] = verticesPerSubStage[n] + 1;
        }
        for (i = 0; i < verticesPerSubStage.length; ++i) {
            this.layoutMap[i] = new AbstractSWTVertex[verticesPerSubStage[i]];
            this.largestNumberOfParallelVertices = Math.max(this.largestNumberOfParallelVertices, verticesPerSubStage[i]);
            verticesPerSubStage[i] = 0;
        }
        for (i = 0; i < this.getNumberOfChildren(); ++i) {
            child = this.getChildAt(i);
            if (!(child instanceof AbstractSWTVertex)) continue;
            childVertex = (AbstractSWTVertex)child;
            int index = longestPath - childVertex.getLongestPath(this) - 1;
            int alreadyAdded = verticesPerSubStage[index];
            this.layoutMap[index][alreadyAdded] = childVertex;
            int n = index;
            verticesPerSubStage[n] = verticesPerSubStage[n] + 1;
        }
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    protected void paintInternal(GC gc, Device device) {
        gc.setBackground(ColorScheme.getStageBackgroundColor(device));
        gc.fillRoundRectangle(this.rect.x, this.rect.y, this.rect.width, this.rect.height, 10, 10);
        gc.setForeground(ColorScheme.getStageBorderColor(device));
        gc.drawRoundRectangle(this.rect.x, this.rect.y, this.rect.width, this.rect.height, 10, 10);
    }
}

