/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.AutoCompletionCombo;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public final class SWTNewFailurePatternDialog {
    private static final int WIDTH = 300;
    private static final int HEIGHT = 100;
    private final Shell shell;
    private final AutoCompletionCombo input;
    private final Set<String> takenNames;
    private String returnValue = null;

    public SWTNewFailurePatternDialog(Shell parent, Set<String> nameSuggestions, Set<String> takenNames) {
        this.takenNames = takenNames;
        this.shell = new Shell(parent);
        this.shell.setSize(300, 100);
        this.shell.setText("Add New Failure Pattern");
        this.shell.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        HashSet<String> nameSugg = new HashSet<String>(nameSuggestions);
        nameSugg.removeAll(takenNames);
        this.input = new AutoCompletionCombo((Composite)this.shell, 0, nameSugg);
        this.input.setLayoutData(gridData);
        this.input.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent arg0) {
                if (arg0.character != '\r') {
                    return;
                }
                if (SWTNewFailurePatternDialog.this.isInputValid()) {
                    SWTNewFailurePatternDialog.this.returnValue = SWTNewFailurePatternDialog.this.input.getText();
                    SWTNewFailurePatternDialog.this.shell.dispose();
                }
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        gridData.verticalAlignment = 1024;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        Composite buttonComposite = new Composite((Composite)this.shell, 0x4000000);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.marginBottom = 0;
        rowLayout.marginHeight = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginWidth = 0;
        rowLayout.pack = false;
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setLayout((Layout)rowLayout);
        Button ok = new Button(buttonComposite, 8);
        ok.setText("OK");
        ok.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (SWTNewFailurePatternDialog.this.isInputValid()) {
                    SWTNewFailurePatternDialog.this.returnValue = SWTNewFailurePatternDialog.this.input.getText();
                    SWTNewFailurePatternDialog.this.shell.dispose();
                }
            }
        });
        Button cancel = new Button(buttonComposite, 8);
        cancel.setText("Cancel");
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SWTNewFailurePatternDialog.this.returnValue = null;
                SWTNewFailurePatternDialog.this.shell.dispose();
            }
        });
    }

    private boolean isInputValid() {
        String text = this.input.getText();
        if (text.isEmpty()) {
            MessageBox messageBox = new MessageBox(this.shell, 1);
            messageBox.setText("Invalid Input");
            messageBox.setMessage("Name for failure pattern must not be empty.");
            messageBox.open();
            this.input.setFocus();
            return false;
        }
        if (this.takenNames.contains(text)) {
            MessageBox messageBox = new MessageBox(this.shell, 1);
            messageBox.setText("Invalid Input");
            messageBox.setMessage("The chosen name is already used by another loaded failure pattern.");
            messageBox.open();
            this.input.setFocus();
            return false;
        }
        return true;
    }

    public String showDialog() {
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.returnValue;
    }
}

