/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.AbstractSWTComponent;
import eu.stratosphere.addons.visualization.swt.ColorScheme;
import eu.stratosphere.addons.visualization.swt.SWTNetworkNode;
import eu.stratosphere.nephele.topology.NetworkTopology;
import java.util.Iterator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class SWTNetworkTopology
extends AbstractSWTComponent {
    private final NetworkTopology networkTopology;
    private SWTNetworkNode rootNode;

    protected SWTNetworkTopology(NetworkTopology networkTopology) {
        super(null);
        this.networkTopology = networkTopology;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public void layout() {
        int depth = this.networkTopology.getDepth();
        if (depth == 0) {
            return;
        }
        int[] nodesPerLevel = new int[depth];
        int[] nodesLayoutedPerLevel = new int[depth];
        int cellHeight = this.rect.height / depth;
        for (int i = 0; i < depth; ++i) {
            nodesPerLevel[i] = this.rootNode.getNumberOfNodesOnLevel(i + 1);
            nodesLayoutedPerLevel[i] = 0;
        }
        Iterator<AbstractSWTComponent> it = this.getChildren();
        while (it.hasNext()) {
            AbstractSWTComponent abstractSWTComponent = it.next();
            if (!(abstractSWTComponent instanceof SWTNetworkNode)) continue;
            SWTNetworkNode swtNetworkNode = (SWTNetworkNode)abstractSWTComponent;
            int nodeDepth = swtNetworkNode.getDepth() - 1;
            int cellWidth = this.rect.width / nodesPerLevel[nodeDepth];
            swtNetworkNode.setHeight(Math.min(cellHeight, 120));
            swtNetworkNode.setWidth(Math.min(cellWidth, 200));
            int y = this.rect.y + nodeDepth * cellHeight;
            if (120 < cellHeight) {
                y += (cellHeight - 120) / 2;
            }
            swtNetworkNode.setY(y);
            int x = this.rect.x + this.rect.width / 2 - nodesPerLevel[nodeDepth] * cellWidth / 2;
            int n = nodeDepth;
            int n2 = nodesLayoutedPerLevel[n];
            nodesLayoutedPerLevel[n] = n2 + 1;
            x += n2 * cellWidth;
            if (200 < cellWidth) {
                x += (cellWidth - 200) / 2;
            }
            swtNetworkNode.setX(x);
        }
        this.layoutChildren();
    }

    public void setRootNode(SWTNetworkNode rootNode) {
        this.rootNode = rootNode;
    }

    @Override
    protected void paintInternal(GC gc, Device device) {
        gc.setBackground(ColorScheme.getNetworkTopologyBackgroundColor(device));
        gc.fillRectangle(this.rect);
    }
}

