/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.visualization.swt;

import eu.stratosphere.addons.visualization.swt.AbstractSWTComponent;
import eu.stratosphere.addons.visualization.swt.ColorScheme;
import eu.stratosphere.addons.visualization.swt.SWTInstanceToolTip;
import eu.stratosphere.addons.visualization.swt.SWTToolTip;
import eu.stratosphere.addons.visualization.swt.SWTToolTipCommandReceiver;
import eu.stratosphere.nephele.topology.NetworkNode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SWTNetworkNode
extends AbstractSWTComponent {
    public static final int MAXWIDTH = 200;
    public static final int MAXHEIGHT = 120;
    private static final int TEXTBOXHEIGHT = 24;
    private static final int TEXTBOXSPACING = 10;
    private static Image LEAFNODEIMAGE;
    private final Image leafNodeImage;
    private final Rectangle leafNodeImageRect;
    private static Rectangle LEAFNODEIMAGERECT;
    private static Image NODEIMAGE;
    private static Rectangle NODEIMAGERECT;
    private final Image nodeImage;
    private final Rectangle nodeImageRect;
    private final NetworkNode networkNode;
    private SWTNetworkNode parentNode = null;
    private List<SWTNetworkNode> childNodes = new ArrayList<SWTNetworkNode>();
    private int depth = -1;
    private float imageScaleFactor = 1.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWTNetworkNode(Display display, AbstractSWTComponent parentComponent, NetworkNode networkNode) {
        super(parentComponent);
        this.networkNode = networkNode;
        Class<SWTNetworkNode> clazz = SWTNetworkNode.class;
        synchronized (SWTNetworkNode.class) {
            InputStream in;
            if (LEAFNODEIMAGE == null) {
                in = this.getClass().getResourceAsStream("/eu/stratosphere/nephele/visualization/swt/leafnode.png");
                try {
                    LEAFNODEIMAGE = new Image((Device)display, in);
                    LEAFNODEIMAGERECT = LEAFNODEIMAGE.getBounds();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.leafNodeImage = LEAFNODEIMAGE;
            this.leafNodeImageRect = LEAFNODEIMAGERECT;
            if (NODEIMAGE == null) {
                in = this.getClass().getResourceAsStream("/eu/stratosphere/nephele/visualization/swt/node.png");
                try {
                    NODEIMAGE = new Image((Device)display, in);
                    NODEIMAGERECT = NODEIMAGE.getBounds();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.nodeImage = NODEIMAGE;
            this.nodeImageRect = NODEIMAGERECT;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    void setParentNode(SWTNetworkNode parentNode) {
        this.parentNode = parentNode;
        this.parentNode.addChildNode(this);
    }

    protected void addChildNode(SWTNetworkNode childNode) {
        this.childNodes.add(childNode);
    }

    public NetworkNode getNetworkNode() {
        return this.networkNode;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    public int getDepth() {
        if (this.depth < 0) {
            this.depth = this.networkNode.getDepth();
        }
        return this.depth;
    }

    int getNumberOfNodesOnLevel(int level) {
        int numberOfNodesOnLevel = 0;
        if (level == this.getDepth()) {
            ++numberOfNodesOnLevel;
        }
        if (level > this.getDepth()) {
            Iterator<SWTNetworkNode> it = this.childNodes.iterator();
            while (it.hasNext()) {
                numberOfNodesOnLevel += it.next().getNumberOfNodesOnLevel(level);
            }
        }
        return numberOfNodesOnLevel;
    }

    @Override
    public void layout() {
        if (this.networkNode.isLeafNode()) {
            if (this.leafNodeImage != null) {
                this.imageScaleFactor = (float)(this.rect.height - 24) / (float)this.leafNodeImageRect.height;
            }
        } else if (this.nodeImage != null) {
            this.imageScaleFactor = (float)(this.rect.height - 24) / (float)this.nodeImageRect.height;
        }
    }

    @Override
    protected void paintInternal(GC gc, Device device) {
        int destY;
        int destX;
        int destWidth;
        int destHeight;
        if (this.parentNode != null) {
            gc.drawLine(this.rect.x + this.rect.width / 2, this.rect.y + (this.rect.height - 24) / 2, this.parentNode.getX() + this.parentNode.getWidth() / 2, this.parentNode.getY() + this.parentNode.getHeight());
        }
        if (this.networkNode.isLeafNode()) {
            if (this.leafNodeImage != null) {
                destHeight = (int)((float)this.leafNodeImageRect.height * this.imageScaleFactor);
                destWidth = (int)((float)this.leafNodeImageRect.width * this.imageScaleFactor);
                destX = this.rect.x + (this.rect.width - destWidth) / 2;
                destY = this.rect.y + (this.rect.height - 24 - destHeight) / 2;
                gc.drawImage(this.leafNodeImage, this.leafNodeImageRect.x, this.leafNodeImageRect.y, this.leafNodeImageRect.width, this.leafNodeImageRect.height, destX, destY, destWidth, destHeight);
            }
        } else if (this.nodeImage != null) {
            destHeight = (int)((float)this.nodeImageRect.height * this.imageScaleFactor);
            destWidth = (int)((float)this.nodeImageRect.width * this.imageScaleFactor);
            destX = this.rect.x + (this.rect.width - destWidth) / 2;
            destY = this.rect.y + (this.rect.height - 24 - destHeight) / 2;
            gc.drawImage(this.nodeImage, this.nodeImageRect.x, this.nodeImageRect.y, this.nodeImageRect.width, this.nodeImageRect.height, destX, destY, destWidth, destHeight);
        }
        String name = this.networkNode.getName();
        Point pt = gc.textExtent(name);
        boolean cropped = false;
        while (pt.x > this.rect.width) {
            cropped = true;
            name = name.substring(0, name.length() - 1);
            pt = gc.textExtent(name + "...");
        }
        if (cropped) {
            name = name + "...";
        }
        gc.setBackground(ColorScheme.getNetworkNodeBackgroundColor(device));
        gc.fillRectangle(this.rect.x + (this.rect.width - pt.x) / 2 - 10, this.rect.y + this.rect.height - 24, pt.x + 20, 24);
        gc.setForeground(ColorScheme.getNetworkNodeBorderColor(device));
        gc.drawRectangle(this.rect.x + (this.rect.width - pt.x) / 2 - 10, this.rect.y + this.rect.height - 24, pt.x + 20, 24);
        gc.setForeground(ColorScheme.getNetworkNodeBorderColor(device));
        int textX = this.rect.x + (this.rect.width - pt.x) / 2;
        int textY = this.rect.y + this.rect.height - 24 + (24 - pt.y) / 2;
        gc.drawText(name, textX, textY);
    }

    @Override
    public SWTToolTip constructToolTip(Shell parentShell, SWTToolTipCommandReceiver commandReceiver, int x, int y) {
        return new SWTInstanceToolTip(parentShell, commandReceiver, this.networkNode, x, y);
    }
}

